/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.analyzer;

import com.dianping.cat.Cat;
import com.dianping.cat.analyzer.EventAggregator;
import com.dianping.cat.analyzer.MetricAggregator;
import com.dianping.cat.analyzer.MetricTagAggregator;
import com.dianping.cat.analyzer.TransactionAggregator;
import com.dianping.cat.analyzer.ptest.PtestEventAggregator;
import com.dianping.cat.analyzer.ptest.PtestMetricAggregator;
import com.dianping.cat.analyzer.ptest.PtestMetricTagAggregator;
import com.dianping.cat.analyzer.ptest.PtestTransactionAggregator;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageTree;
import java.util.List;
import org.unidal.helper.Threads;

public class LocalAggregator {
    public static void aggregate(MessageTree tree, boolean isPtest) {
        if (isPtest) {
            LocalAggregator.analyzerPtestProcessTree(tree);
        } else {
            LocalAggregator.analyzerProcessTree(tree);
        }
    }

    private static void analyzerProcessTransaction(Transaction transaction) {
        TransactionAggregator.getInstance().logTransaction(transaction);
        List<Message> child = transaction.getChildren();
        for (Message message : child) {
            if (message instanceof Transaction) {
                LocalAggregator.analyzerProcessTransaction((Transaction)message);
                continue;
            }
            if (!(message instanceof Event)) continue;
            EventAggregator.getInstance().logEvent((Event)message);
        }
    }

    private static void analyzerProcessTree(MessageTree tree) {
        Message message = tree.getMessage();
        if (message instanceof Transaction) {
            LocalAggregator.analyzerProcessTransaction((Transaction)message);
        } else if (message instanceof Event) {
            EventAggregator.getInstance().logEvent((Event)message);
        }
    }

    private static void analyzerPtestProcessTransaction(Transaction transaction) {
        PtestTransactionAggregator.getInstance().logTransaction(transaction);
        List<Message> child = transaction.getChildren();
        for (Message message : child) {
            if (message instanceof Transaction) {
                LocalAggregator.analyzerPtestProcessTransaction((Transaction)message);
                continue;
            }
            if (!(message instanceof Event)) continue;
            PtestEventAggregator.getInstance().logEvent((Event)message);
        }
    }

    private static void analyzerPtestProcessTree(MessageTree tree) {
        Message message = tree.getMessage();
        if (message instanceof Transaction) {
            LocalAggregator.analyzerPtestProcessTransaction((Transaction)message);
        } else if (message instanceof Event) {
            PtestEventAggregator.getInstance().logEvent((Event)message);
        }
    }

    public static class DataUploader
    implements Threads.Task {
        private boolean m_active = true;

        public String getName() {
            return "data-uploader";
        }

        public void run() {
            while (this.m_active) {
                long duration;
                long start = System.currentTimeMillis();
                try {
                    MetricAggregator.getInstance().sendMetricData();
                    TransactionAggregator.getInstance().sendTransactionData();
                    EventAggregator.getInstance().sendEventData();
                    MetricTagAggregator.getInstance().sendMetricTagData();
                    PtestMetricAggregator.getInstance().sendMetricData();
                    PtestTransactionAggregator.getInstance().sendTransactionData();
                    PtestEventAggregator.getInstance().sendEventData();
                    PtestMetricTagAggregator.getInstance().sendMetricTagData();
                }
                catch (Exception ex) {
                    Cat.logError(ex);
                }
                if ((duration = System.currentTimeMillis() - start) >= 1000L) continue;
                try {
                    Thread.sleep(1000L - duration);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        public void shutdown() {
            this.m_active = false;
        }
    }
}

