/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.analyzer;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageTree;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class EventAggregator {
    private static EventAggregator s_instance = new EventAggregator();
    private ConcurrentHashMap<String, ConcurrentHashMap<String, EventData>> m_events = new ConcurrentHashMap();

    public static EventAggregator getInstance() {
        return s_instance;
    }

    private EventData createEventData(String type, String name) {
        return new EventData(type, name);
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<String, EventData>> getAndResetEvents() {
        ConcurrentHashMap<String, ConcurrentHashMap<String, EventData>> cloned = this.m_events;
        this.m_events = new ConcurrentHashMap();
        for (Map.Entry<String, ConcurrentHashMap<String, EventData>> entry : cloned.entrySet()) {
            String type = entry.getKey();
            this.m_events.putIfAbsent(type, new ConcurrentHashMap());
        }
        return cloned;
    }

    public String getDomain(MessageTree tree) {
        return tree.getDomain();
    }

    public void logBatchEvent(String type, String name, int total, int fail) {
        this.makeSureEventExist(type, name).add(total, fail);
    }

    public void logEvent(Event e) {
        this.makeSureEventExist(e.getType(), e.getName()).add(e);
    }

    private EventData makeSureEventExist(String type, String name) {
        EventData data;
        ConcurrentHashMap<String, EventData> oldValue;
        ConcurrentHashMap<String, EventData> item = this.m_events.get(type);
        if (null == item && (oldValue = this.m_events.putIfAbsent(type, item = new ConcurrentHashMap())) != null) {
            item = oldValue;
        }
        if (null == (data = item.get(name))) {
            data = this.createEventData(type, name);
            EventData oldValue2 = item.putIfAbsent(name, data);
            if (oldValue2 == null) {
                return data;
            }
            return oldValue2;
        }
        return data;
    }

    public void sendEventData() {
        ConcurrentHashMap<String, ConcurrentHashMap<String, EventData>> events = this.getAndResetEvents();
        boolean hasData = false;
        block0: for (Map map : events.values()) {
            for (EventData eventData : map.values()) {
                if (eventData.getCount() <= 0) continue;
                hasData = true;
                continue block0;
            }
        }
        if (hasData && events.size() > 0) {
            Transaction t = Cat.newTransaction("System", this.getClass().getSimpleName());
            MessageTree messageTree = Cat.getManager().getThreadLocalMessageTree();
            messageTree.setDomain(this.getDomain(messageTree));
            messageTree.setDiscard(false);
            for (Map map : events.values()) {
                for (EventData data : map.values()) {
                    if (data.getCount() <= 0) continue;
                    Event tmp = Cat.newEvent(data.getType(), data.getName());
                    StringBuilder sb = new StringBuilder(32);
                    sb.append('@').append(data.getCount()).append(";").append(data.getError());
                    tmp.addData(sb.toString());
                    tmp.setSuccessStatus();
                    tmp.complete();
                }
            }
            t.setSuccessStatus();
            t.complete();
        }
    }

    public class EventData {
        private String m_type;
        private String m_name;
        private AtomicInteger m_count = new AtomicInteger();
        private AtomicInteger m_error = new AtomicInteger();

        public EventData(String type, String name) {
            this.m_type = type;
            this.m_name = name;
        }

        public EventData add(Event e) {
            this.m_count.incrementAndGet();
            if (!e.isSuccess()) {
                this.m_error.incrementAndGet();
            }
            return this;
        }

        public EventData add(int count, int fail) {
            this.m_count.addAndGet(count);
            this.m_error.addAndGet(fail);
            return this;
        }

        public int getCount() {
            return this.m_count.get();
        }

        public int getError() {
            return this.m_error.get();
        }

        public String getName() {
            return this.m_name;
        }

        public String getType() {
            return this.m_type;
        }
    }
}

