/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat;

import com.dianping.cat.analyzer.EventAggregator;
import com.dianping.cat.analyzer.MetricAggregator;
import com.dianping.cat.analyzer.MetricTagAggregator;
import com.dianping.cat.analyzer.TransactionAggregator;
import com.dianping.cat.analyzer.ptest.PtestEventAggregator;
import com.dianping.cat.analyzer.ptest.PtestMetricAggregator;
import com.dianping.cat.analyzer.ptest.PtestMetricTagAggregator;
import com.dianping.cat.analyzer.ptest.PtestTransactionAggregator;
import com.dianping.cat.configuration.ApplicationEnvironment;
import com.dianping.cat.configuration.client.entity.ClientConfig;
import com.dianping.cat.configuration.client.entity.Server;
import com.dianping.cat.configuration.client.transform.DefaultSaxParser;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.MessageProducer;
import com.dianping.cat.message.Trace;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.NullMessage;
import com.dianping.cat.message.internal.NullMessageManager;
import com.dianping.cat.message.internal.NullMessageProducer;
import com.dianping.cat.message.spi.MessageManager;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.util.MtraceTracer;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.unidal.helper.Properties;
import org.unidal.initialization.DefaultModuleContext;
import org.unidal.initialization.Module;
import org.unidal.initialization.ModuleContext;
import org.unidal.initialization.ModuleInitializer;
import org.unidal.lookup.ContainerLoader;
import org.unidal.lookup.util.StringUtils;

public class Cat {
    private MessageProducer m_producer;
    private MessageManager m_manager;
    private static int m_errorCount;
    private static Cat s_instance;
    private static volatile boolean s_init;
    private static volatile boolean s_enabled;
    private static volatile boolean s_perfTest;
    public static final String CLENT_CONFIG = "cat-client-config";
    public static final String UNKNOWN = "unknown";

    private static void checkAndInitialize() {
        if (Cat.isEnabled()) {
            try {
                if (!s_init) {
                    Cat.initialize();
                }
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static String createMessageId() {
        if (Cat.isEnabled()) {
            try {
                return Cat.getProducer().createMessageId();
            }
            catch (Exception e) {
                Cat.errorHandler(e);
                return NullMessageProducer.NULL_MESSAGE_PRODUCER.createMessageId();
            }
        }
        return NullMessageProducer.NULL_MESSAGE_PRODUCER.createMessageId();
    }

    public static void disable() {
        s_enabled = false;
    }

    public static void disableTest() {
        s_perfTest = false;
    }

    public static void enable() {
        s_enabled = true;
    }

    private static void errorHandler(Exception e) {
        if (Cat.isEnabled() && m_errorCount < 3) {
            ++m_errorCount;
            e.printStackTrace();
        }
    }

    public static String getCatHome() {
        String catHome = (String)Properties.forString().fromEnv().fromSystem().getProperty("CAT_HOME", (Object)"/data/appdatas/cat/");
        return catHome;
    }

    public static String getCurrentMessageId() {
        if (Cat.isEnabled()) {
            try {
                MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
                if (tree != null) {
                    String messageId = tree.getMessageId();
                    if (messageId == null) {
                        messageId = Cat.getProducer().createMessageId();
                        tree.setMessageId(messageId);
                    }
                    return messageId;
                }
                return null;
            }
            catch (Exception e) {
                Cat.errorHandler(e);
                return NullMessageProducer.NULL_MESSAGE_PRODUCER.createMessageId();
            }
        }
        return NullMessageProducer.NULL_MESSAGE_PRODUCER.createMessageId();
    }

    private static String getCustomDomain() {
        String config = System.getProperty(CLENT_CONFIG);
        if (StringUtils.isNotEmpty((String)config)) {
            try {
                ClientConfig clientConfig = DefaultSaxParser.parse(config);
                return clientConfig.getDomain();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Cat getInstance() {
        return s_instance;
    }

    public static MessageManager getManager() {
        if (Cat.isEnabled()) {
            try {
                Cat.checkAndInitialize();
                MessageManager manager = Cat.s_instance.m_manager;
                if (manager != null) {
                    return manager;
                }
                return NullMessageManager.NULL_MESSAGE_MANAGER;
            }
            catch (Exception e) {
                Cat.errorHandler(e);
                return NullMessageManager.NULL_MESSAGE_MANAGER;
            }
        }
        return NullMessageManager.NULL_MESSAGE_MANAGER;
    }

    public static MessageProducer getProducer() {
        if (Cat.isEnabled()) {
            try {
                Cat.checkAndInitialize();
                MessageProducer producer = Cat.s_instance.m_producer;
                if (producer != null) {
                    return producer;
                }
                return NullMessageProducer.NULL_MESSAGE_PRODUCER;
            }
            catch (Exception e) {
                Cat.errorHandler(e);
                return NullMessageProducer.NULL_MESSAGE_PRODUCER;
            }
        }
        return NullMessageProducer.NULL_MESSAGE_PRODUCER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() {
        block8: {
            Cat.validate();
            if (Cat.isEnabled()) {
                try {
                    if (s_init) break block8;
                    Cat cat = s_instance;
                    synchronized (cat) {
                        if (!s_init) {
                            PlexusContainer container = ContainerLoader.getDefaultContainer();
                            DefaultModuleContext ctx = new DefaultModuleContext(container);
                            Module module = (Module)ctx.lookup(Module.class, "cat-client");
                            if (!module.isInitialized()) {
                                ModuleInitializer initializer = (ModuleInitializer)ctx.lookup(ModuleInitializer.class);
                                initializer.execute((ModuleContext)ctx, new Module[]{module});
                            }
                            Cat.log("info", "Cat is lazy initialized!");
                            s_init = true;
                        }
                    }
                }
                catch (Exception e) {
                    Cat.errorHandler(e);
                    Cat.disable();
                    Cat.errorHandler(e);
                }
            }
        }
    }

    private static void initialize(ClientConfig config) {
        if (Cat.isEnabled()) {
            System.setProperty(CLENT_CONFIG, config.toString());
            Cat.log("info", "init cat with config:" + config.toString());
            Cat.initialize();
        }
    }

    public static void initialize(PlexusContainer container, File configFile) {
    }

    public static void initialize(String ... servers) {
        if (Cat.isEnabled() && !s_init) {
            try {
                ClientConfig config = new ClientConfig();
                for (String server : servers) {
                    config.addServer(new Server(server));
                }
                String domain = ApplicationEnvironment.loadAppName(UNKNOWN);
                config.setDomain(domain);
                Cat.initialize(config);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void initializeByDomain(String domain) {
        if (Cat.isEnabled() && !s_init) {
            try {
                String domainName = ApplicationEnvironment.loadAppName(domain);
                ClientConfig config = ApplicationEnvironment.loadClientConfig(domainName);
                Cat.initialize(config);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void initializeByDomain(String domain, int port, int httpPort, String ... servers) {
        if (Cat.isEnabled() && !s_init) {
            try {
                ClientConfig config = new ClientConfig();
                config.setDomain(ApplicationEnvironment.loadAppName(domain));
                for (String server : servers) {
                    Server serverObj = new Server(server);
                    serverObj.setHttpPort(httpPort);
                    serverObj.setPort(port);
                    config.addServer(serverObj);
                }
                Cat.initialize(config);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void initializeByDomain(String domain, String ... servers) {
        if (Cat.isEnabled() && !s_init) {
            try {
                Cat.initializeByDomain(domain, 2280, 80, servers);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void initializeByDomainForce(String domain) {
        if (Cat.isEnabled() && !s_init) {
            try {
                ClientConfig config = ApplicationEnvironment.loadClientConfig(domain);
                Cat.initialize(config);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static boolean isEnabled() {
        return s_enabled;
    }

    public static boolean isInitialized() {
        return s_init;
    }

    private static boolean isPerfTest() {
        if (s_perfTest) {
            return MtraceTracer.isTest();
        }
        return false;
    }

    public static boolean isPerfTestEnable() {
        return s_perfTest;
    }

    private static void log(String severity, String message) {
        MessageFormat format = new MessageFormat("[{0,date,MM-dd HH:mm:ss.sss}] [{1}] [{2}] {3}");
        System.out.println(format.format(new Object[]{new Date(), severity, "cat", message}));
    }

    public static void logBatchEvent(String type, String name, int count, int error) {
        if (Cat.isEnabled()) {
            try {
                if (Cat.isPerfTest()) {
                    PtestEventAggregator.getInstance().logBatchEvent(type, name, count, error);
                } else {
                    EventAggregator.getInstance().logBatchEvent(type, name, count, error);
                }
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logBatchTransaction(String type, String name, int count, int error, long sum) {
        if (Cat.isEnabled()) {
            if (Cat.isPerfTest()) {
                PtestTransactionAggregator.getInstance().logBatchTransaction(type, name, count, error, sum);
            } else {
                TransactionAggregator.getInstance().logBatchTransaction(type, name, count, error, sum);
            }
        }
    }

    public static void logError(String message, Throwable cause) {
        if (Cat.isEnabled()) {
            try {
                Cat.getProducer().logError(message, cause);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logError(Throwable cause) {
        if (Cat.isEnabled()) {
            try {
                Cat.getProducer().logError(cause);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logErrorWithCategory(String category, String message, Throwable cause) {
        if (Cat.isEnabled()) {
            try {
                Cat.getProducer().logErrorWithCategory(category, message, cause);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logErrorWithCategory(String category, Throwable cause) {
        if (Cat.isEnabled()) {
            try {
                Cat.getProducer().logErrorWithCategory(category, cause);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logEvent(String type, String name) {
        if (Cat.isEnabled()) {
            try {
                Cat.getProducer().logEvent(type, name);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logEvent(String type, String name, String status, String nameValuePairs) {
        if (Cat.isEnabled()) {
            try {
                Cat.getProducer().logEvent(type, name, status, nameValuePairs);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logMetricForCount(String name) {
        if (Cat.isEnabled()) {
            try {
                if (Cat.isPerfTest()) {
                    PtestMetricAggregator.getInstance().addCountMetric(name, 1);
                } else {
                    MetricAggregator.getInstance().addCountMetric(name, 1);
                }
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logMetricForCount(String name, int quantity) {
        if (Cat.isEnabled()) {
            try {
                if (Cat.isPerfTest()) {
                    PtestMetricAggregator.getInstance().addCountMetric(name, quantity);
                } else {
                    MetricAggregator.getInstance().addCountMetric(name, quantity);
                }
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logMetricForCount(String name, int quantity, Map<String, String> tags) {
        if (Cat.isEnabled()) {
            try {
                if (Cat.isPerfTest()) {
                    PtestMetricTagAggregator.getInstance().addCountMetric(name, quantity, tags);
                } else {
                    MetricTagAggregator.getInstance().addCountMetric(name, quantity, tags);
                }
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logMetricForCount(String name, Map<String, String> tags) {
        if (Cat.isEnabled()) {
            try {
                if (Cat.isPerfTest()) {
                    PtestMetricTagAggregator.getInstance().addCountMetric(name, 1, tags);
                } else {
                    MetricTagAggregator.getInstance().addCountMetric(name, 1, tags);
                }
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logMetricForDuration(String name, long durationInMillis) {
        if (Cat.isEnabled()) {
            try {
                if (Cat.isPerfTest()) {
                    PtestMetricAggregator.getInstance().addTimerMetric(name, durationInMillis);
                } else {
                    MetricAggregator.getInstance().addTimerMetric(name, durationInMillis);
                }
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logMetricForDuration(String name, long durationInMillis, Map<String, String> tags) {
        if (Cat.isEnabled()) {
            try {
                if (Cat.isPerfTest()) {
                    PtestMetricTagAggregator.getInstance().addTimerMetric(name, durationInMillis, tags);
                } else {
                    MetricTagAggregator.getInstance().addTimerMetric(name, durationInMillis, tags);
                }
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logMetricForLatestValue(String name, int quantity) {
    }

    public static void logMetricForSum(String name, double value) {
    }

    public static void logMetricForSum(String name, double sum, int quantity) {
    }

    public static void logRemoteCallClient(Context ctx) {
        if (Cat.isEnabled()) {
            try {
                Cat.logRemoteCallClient(ctx, "default");
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logRemoteCallClient(Context ctx, String domain) {
        if (Cat.isEnabled()) {
            try {
                MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
                String messageId = tree.getMessageId();
                if (messageId == null) {
                    messageId = Cat.getProducer().createMessageId();
                    tree.setMessageId(messageId);
                }
                String childId = Cat.getProducer().createRpcServerId(domain);
                Cat.logEvent("RemoteCall", "", "0", childId);
                String root = tree.getRootMessageId();
                if (root == null) {
                    root = messageId;
                }
                ctx.addProperty("_catRootMessageId", root);
                ctx.addProperty("_catParentMessageId", messageId);
                ctx.addProperty("_catChildMessageId", childId);
                boolean canDiscard = Cat.getManager().getThreadLocalMessageTree().canDiscard();
                if (!canDiscard) {
                    ctx.addProperty("_catDiscard", "false");
                }
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logRemoteCallServer(Context ctx) {
        if (Cat.isEnabled()) {
            try {
                String discard;
                MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
                String childId = ctx.getProperty("_catChildMessageId");
                String rootId = ctx.getProperty("_catRootMessageId");
                String parentId = ctx.getProperty("_catParentMessageId");
                if (parentId != null) {
                    tree.setParentMessageId(parentId);
                }
                if (rootId != null) {
                    tree.setRootMessageId(rootId);
                }
                if (childId != null) {
                    tree.setMessageId(childId);
                }
                if ((discard = ctx.getProperty("_catDiscard")) != null && "false".equals(discard)) {
                    Cat.getManager().getThreadLocalMessageTree().setDiscard(false);
                }
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logTrace(String type, String name) {
        if (Cat.isEnabled()) {
            try {
                Cat.getProducer().logTrace(type, name);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void logTrace(String type, String name, String status, String nameValuePairs) {
        if (Cat.isEnabled()) {
            try {
                Cat.getProducer().logTrace(type, name, status, nameValuePairs);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void newCompletedTransactionWithDuration(String type, String name, long duration) {
        if (Cat.isEnabled()) {
            try {
                Transaction transaction = Cat.getProducer().newTransaction(type, name);
                try {
                    transaction.setDurationInMillis(duration);
                    transaction.setStatus("0");
                }
                catch (Exception e) {
                    transaction.setStatus(e);
                }
                finally {
                    transaction.complete();
                }
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static Event newEvent(String type, String name) {
        if (Cat.isEnabled()) {
            try {
                return Cat.getProducer().newEvent(type, name);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
                return NullMessage.EVENT;
            }
        }
        return NullMessage.EVENT;
    }

    public static Trace newTrace(String type, String name) {
        if (Cat.isEnabled()) {
            try {
                return Cat.getProducer().newTrace(type, name);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
                return NullMessage.TRACE;
            }
        }
        return NullMessage.TRACE;
    }

    public static Transaction newTransaction(String type, String name) {
        if (Cat.isEnabled()) {
            try {
                return Cat.getProducer().newTransaction(type, name);
            }
            catch (Exception e) {
                Cat.errorHandler(e);
                return NullMessage.TRANSACTION;
            }
        }
        return NullMessage.TRANSACTION;
    }

    public static Transaction newTransactionWithDuration(String type, String name, long duration) {
        if (Cat.isEnabled()) {
            try {
                Transaction transaction = Cat.getProducer().newTransaction(type, name);
                transaction.setDurationInMillis(duration);
                return transaction;
            }
            catch (Exception e) {
                Cat.errorHandler(e);
                return NullMessage.TRANSACTION;
            }
        }
        return NullMessage.TRANSACTION;
    }

    public static void setMetricSlowThreshold(String key, int slow) {
        if (Cat.isEnabled()) {
            MetricAggregator.getInstance().setMetricSlowThreshold(key, slow);
            PtestMetricAggregator.getInstance().setMetricSlowThreshold(key, slow);
        }
    }

    public static void setup(String sessionToken) {
        if (Cat.isEnabled()) {
            try {
                Cat.getManager().setup();
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    private static void validate() {
        String enable = (String)Properties.forString().fromEnv().fromSystem().getProperty("CAT_ENABLED", (Object)"true");
        if ("false".equals(enable)) {
            Cat.log("warn", "CAT is disable due to system enviorment CAT_ENABLED is false.");
            s_enabled = false;
        } else {
            String customDomain = Cat.getCustomDomain();
            if (customDomain == null && UNKNOWN.equals(ApplicationEnvironment.loadAppName(UNKNOWN))) {
                Cat.log("warn", "CAT is disable due to no app name in resource file /META-INF/app.properties");
                s_enabled = false;
            }
        }
    }

    private Cat() {
    }

    public void setContainer(PlexusContainer container) {
        try {
            this.m_manager = (MessageManager)container.lookup(MessageManager.class);
            this.m_producer = (MessageProducer)container.lookup(MessageProducer.class);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Unable to get instance of MessageManager, please make sure the environment was setup correctly!", e);
        }
    }

    static {
        s_instance = new Cat();
        s_init = false;
        s_enabled = true;
        s_perfTest = true;
    }

    public static interface Context {
        public static final String ROOT = "_catRootMessageId";
        public static final String PARENT = "_catParentMessageId";
        public static final String CHILD = "_catChildMessageId";
        public static final String DISCARD = "_catDiscard";

        public void addProperty(String var1, String var2);

        public String getProperty(String var1);
    }
}

