/*
 * Decompiled with CFR 0.152.
 */
package john.walker.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import john.walker.log.AbstractLogger;

public class FileLogger
extends AbstractLogger {
    public static String logFileName = "dbtrace.log";
    private static SimpleDateFormat format = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS");
    private RandomAccessFile raf;

    public FileLogger() {
        File file;
        String rootPath = System.getProperty("catalina.home");
        if (rootPath == null || rootPath.isEmpty()) {
            rootPath = System.getProperty("user.dir");
        }
        if (!new File(rootPath = rootPath + File.separator + "logs").exists()) {
            new File(rootPath).mkdirs();
        }
        if ((file = new File(rootPath + File.separator + logFileName)).exists()) {
            if (file.length() > 0L) {
                file.renameTo(new File(file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - 4) + "_" + format.format(new Date()) + ".log"));
            }
        } else {
            file.getParentFile().mkdirs();
        }
        System.out.println("\u65e5\u5fd7\u6587\u4ef6\u8def\u5f84\uff1a " + file.getAbsolutePath());
        try {
            this.raf = new RandomAccessFile(file, "rw");
            if (this.raf.length() > 0L) {
                this.raf.seek(this.raf.length());
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    FileLogger.this.destroy();
                }
            });
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setLogPath(String absolutePath) {
        if (absolutePath == null || absolutePath.trim().isEmpty()) {
            throw new RuntimeException("the path can not be empty!");
        }
        File file = new File(absolutePath);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.raf != null) {
            try {
                this.raf.close();
                this.raf = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.raf = new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void debug(String msg) {
        if (this.raf != null) {
            try {
                this.raf.write(msg.getBytes());
                this.raf.write("\r\n".getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void info(String msg) {
        this.debug(msg);
    }

    @Override
    public void warn(String msg) {
        this.debug(msg);
    }

    @Override
    public void error(String msg) {
        this.debug(msg);
    }

    @Override
    public void fatal(String msg) {
        this.debug(msg);
    }

    @Override
    public void newLine() {
        if (this.raf != null) {
            try {
                this.raf.seek(this.raf.length());
                this.raf.write("\r\n".getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void destroy() {
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

