/*
 * Decompiled with CFR 0.152.
 */
package john.walker.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import john.walker.log.ConsoleLogger;
import john.walker.log.ILog;
import john.walker.log.LogFactory;
import john.walker.log.MultiLogger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import us.codecraft.xsoup.Xsoup;

public class XmlFileLoader {
    public static String CONFIG_FILE_NAME = "dbtrace.xml";
    private static Document document = null;

    private XmlFileLoader() {
    }

    public static void main(String[] args) {
        System.out.println();
    }

    public static List<String> loadFilterWords() {
        Elements elements = Xsoup.select((Element)document, (String)"//monitor/excludes/exclude").getElements();
        ArrayList<String> words = new ArrayList<String>(elements.size());
        for (Element element : elements) {
            words.add(element.text().trim());
        }
        return words;
    }

    public static void loadLoggers() {
        Elements elements = Xsoup.select((Element)document, (String)"//monitor/loggers/logger").getElements();
        ArrayList<String> loggers = new ArrayList<String>(elements.size());
        for (Element element : elements) {
            loggers.add(element.text().trim());
        }
        MultiLogger mutiLogger = new MultiLogger();
        boolean hasOne = false;
        for (String loggerClassName : loggers) {
            try {
                ILog logger = (ILog)Class.forName(loggerClassName).newInstance();
                mutiLogger.addLogger(logger);
                hasOne = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!hasOne) {
            LogFactory.setLogger(new ConsoleLogger());
        } else {
            LogFactory.setLogger(mutiLogger);
        }
    }

    public static boolean sqlMonitor() {
        Elements elements = Xsoup.select((Element)document, (String)"//monitor/queryLog").getElements();
        if (elements == null) {
            return false;
        }
        return Boolean.valueOf(((Element)elements.get(0)).text());
    }

    public static boolean sqlMonitorStack() {
        Elements elements = Xsoup.select((Element)document, (String)"//monitor/queryLogTrace").getElements();
        if (elements == null) {
            return false;
        }
        return Boolean.valueOf(((Element)elements.get(0)).text());
    }

    public static long sqlMonitorTime() {
        Elements elements = Xsoup.select((Element)document, (String)"//monitor/queryLogThreshold").getElements();
        if (elements == null) {
            return 0L;
        }
        try {
            return Long.valueOf(((Element)elements.get(0)).text());
        }
        catch (Exception e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream in = null;
        try {
            in = loader.getResourceAsStream(CONFIG_FILE_NAME);
            document = Jsoup.parse((InputStream)in, (String)"UTF-8", (String)"");
            System.out.println(XmlFileLoader.loadFilterWords());
        }
        catch (IOException e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            LogFactory.getLogger().log(writer.toString());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

