/*
 * Decompiled with CFR 0.152.
 */
package john.walker.analyse;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.h2.jdbcx.JdbcConnectionPool;

public class LogAnalyser {
    protected static final String DDL = "create table if not exists dbtrace_log ( id int not null auto_increment, hash varchar(32) not null default '', time long not null default 0, sql text, args text, trace text, start_time timestamp, primary key(id) )";
    protected static final String DML = "insert into dbtrace_log (hash, time, sql, args, trace, start_time) values(?, ?, ?, ?, ?, ?)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        JdbcConnectionPool pool = JdbcConnectionPool.create((String)"jdbc:h2:~/h2logdb", (String)"sa", (String)"sa");
        pool.setLoginTimeout(5);
        pool.setMaxConnections(2);
        try {
            Connection con = pool.getConnection();
            PreparedStatement stmt = con.prepareStatement(DDL);
            stmt.execute();
            stmt.close();
            stmt = con.prepareStatement("truncate table dbtrace_log");
            stmt.execute();
            stmt.close();
            con.close();
            File file = new File("logs/dbtrace.log");
            BufferedReader reader = IOUtils.buffer((Reader)new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).startsWith("SQL\u4ee3\u7406\uff1a")) continue;
                String sql = line.substring("SQL\u4ee3\u7406\uff1a".length()).trim();
                line = reader.readLine().trim();
                String sqlArgs = line.substring("SQL\u53c2\u6570\uff1a".length()).trim();
                line = reader.readLine().trim();
                String sqlTimeStr = line.substring("SQL\u8017\u65f6\uff1a".length()).trim();
                long sqlTime = 0L;
                if (sqlTimeStr.endsWith("\u6beb\u79d2")) {
                    sqlTime = Long.valueOf(sqlTimeStr.replace("\u6beb\u79d2", ""));
                } else if (sqlTimeStr.endsWith("\u79d2")) {
                    sqlTime = Long.valueOf(sqlTimeStr.replace("\u79d2", "")) * 1000L;
                } else if (sqlTimeStr.endsWith("\u5206\u949f")) {
                    sqlTime = Long.valueOf(sqlTimeStr.replace("\u5206\u949f", "")) * 60000L;
                } else if (sqlTimeStr.endsWith("\u5c0f\u65f6")) {
                    sqlTime = Long.valueOf(sqlTimeStr.replace("\u5c0f\u65f6", "")) * 3600000L;
                }
                reader.readLine();
                StringBuffer buffer = new StringBuffer();
                while ((line = reader.readLine()) != null && !line.trim().isEmpty()) {
                    buffer.append(line.trim()).append("\n");
                }
                String trace = buffer.toString();
                String hash = DigestUtils.md5Hex((String)sql);
                con = pool.getConnection();
                stmt = con.prepareStatement(DML);
                stmt.setString(1, hash);
                stmt.setLong(2, sqlTime);
                stmt.setString(3, sql);
                stmt.setString(4, sqlArgs);
                stmt.setString(5, trace);
                stmt.setString(6, null);
                stmt.execute();
                stmt.close();
                con.close();
            }
            con = pool.getConnection();
            stmt = con.prepareStatement("select * from dbtrace_log order by time desc limit 10");
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                System.out.println(rs.getInt("id") + ", " + rs.getString("hash") + ", " + rs.getLong("time") + ", " + LogAnalyser.clob2String(rs.getClob("sql")) + ", " + LogAnalyser.clob2String(rs.getClob("args")) + ", " + LogAnalyser.clob2String(rs.getClob("trace")) + ", " + rs.getTimestamp("start_time"));
            }
            rs.close();
            stmt.close();
            con.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            pool.dispose();
        }
    }

    private static String clob2String(Clob clob) {
        if (clob == null) {
            return null;
        }
        try {
            return clob.getSubString(1L, (int)clob.length());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

