/*
 * Decompiled with CFR 0.152.
 */
package john.walker;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import john.walker.ProxyConnection;

public class ProxyStatement
implements Statement {
    private Statement stmt;
    private String sql;

    public ProxyStatement(Statement stmt) {
        this.stmt = stmt;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.sql = "addBatch --> " + sql;
        this.stmt.addBatch(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.stmt.cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.stmt.clearBatch();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.stmt.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.stmt.close();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.stmt.closeOnCompletion();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        long start = System.currentTimeMillis();
        boolean result = this.stmt.execute(sql);
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, sql, start, end);
        return result;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        long start = System.currentTimeMillis();
        boolean result = this.stmt.execute(sql, autoGeneratedKeys);
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, sql, start, end);
        return result;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        long start = System.currentTimeMillis();
        boolean result = this.stmt.execute(sql, columnIndexes);
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, sql, start, end);
        return result;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        long start = System.currentTimeMillis();
        boolean result = this.stmt.execute(sql, columnNames);
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, sql, start, end);
        return result;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        long start = System.currentTimeMillis();
        int[] result = this.stmt.executeBatch();
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, this.sql, start, end);
        return result;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        long start = System.currentTimeMillis();
        ResultSet result = this.stmt.executeQuery(sql);
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, sql, start, end);
        return result;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        long start = System.currentTimeMillis();
        int result = this.stmt.executeUpdate(sql);
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, sql, start, end);
        return result;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        long start = System.currentTimeMillis();
        int result = this.stmt.executeUpdate(sql, autoGeneratedKeys);
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, sql, start, end);
        return result;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        long start = System.currentTimeMillis();
        int result = this.stmt.executeUpdate(sql, columnIndexes);
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, sql, start, end);
        return result;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        long start = System.currentTimeMillis();
        int result = this.stmt.executeUpdate(sql, columnNames);
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, sql, start, end);
        return result;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.stmt.getConnection();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.stmt.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.stmt.getFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.stmt.getGeneratedKeys();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.stmt.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.stmt.getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.stmt.getMoreResults();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.stmt.getMoreResults();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.stmt.getQueryTimeout();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.stmt.getResultSet();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.stmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.stmt.getResultSetHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.stmt.getUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.stmt.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.stmt.isClosed();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.stmt.isCloseOnCompletion();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.stmt.isPoolable();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.stmt.isWrapperFor(iface);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.stmt.setCursorName(name);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.stmt.setEscapeProcessing(enable);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.stmt.setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.stmt.setFetchSize(rows);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.stmt.setMaxFieldSize(max);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.stmt.setMaxRows(max);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.stmt.setPoolable(poolable);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.stmt.setQueryTimeout(seconds);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.stmt.unwrap(iface);
    }
}

