/*
 * Decompiled with CFR 0.152.
 */
package john.walker;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TreeMap;
import john.walker.ProxyConnection;
import john.walker.compare.IntegerComparator;

public class ProxyPreparedStatement
implements PreparedStatement {
    private PreparedStatement stmt;
    private String sql;
    private Map<Integer, Object> parameters = new TreeMap<Integer, Object>(IntegerComparator.me());

    public ProxyPreparedStatement(PreparedStatement stmt, String sql) {
        this.stmt = stmt;
        this.sql = sql;
    }

    @Override
    public void addBatch() throws SQLException {
        this.stmt.addBatch();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.sql = "addBatch --> " + sql;
        this.stmt.addBatch(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.stmt.cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.stmt.clearBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.stmt.clearParameters();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.stmt.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.parameters.clear();
        this.stmt.close();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.parameters.clear();
        this.stmt.closeOnCompletion();
    }

    @Override
    public boolean execute() throws SQLException {
        long start = System.currentTimeMillis();
        boolean result = this.stmt.execute();
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, this.sql, this.parameters.entrySet().toArray(), start, end);
        return result;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        long start = System.currentTimeMillis();
        boolean result = this.stmt.execute(sql);
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, sql, this.parameters.entrySet().toArray(), start, end);
        return result;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        long start = System.currentTimeMillis();
        boolean result = this.stmt.execute(sql, autoGeneratedKeys);
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, sql, this.parameters.entrySet().toArray(), start, end);
        return result;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        long start = System.currentTimeMillis();
        boolean result = this.stmt.execute(sql, columnIndexes);
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, sql, this.parameters.entrySet().toArray(), start, end);
        return result;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        long start = System.currentTimeMillis();
        boolean result = this.stmt.execute(sql, columnNames);
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, sql, this.parameters.entrySet().toArray(), start, end);
        return result;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        long start = System.currentTimeMillis();
        int[] result = this.stmt.executeBatch();
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, this.sql, this.parameters.entrySet().toArray(), start, end);
        return result;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        long start = System.currentTimeMillis();
        ResultSet result = this.stmt.executeQuery();
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, this.sql, this.parameters.entrySet().toArray(), start, end);
        return result;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        long start = System.currentTimeMillis();
        ResultSet result = this.stmt.executeQuery();
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, sql, this.parameters.entrySet().toArray(), start, end);
        return result;
    }

    @Override
    public int executeUpdate() throws SQLException {
        long start = System.currentTimeMillis();
        int result = this.stmt.executeUpdate();
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, this.sql, this.parameters.entrySet().toArray(), start, end);
        return result;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        long start = System.currentTimeMillis();
        int result = this.stmt.executeUpdate(sql);
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, sql, this.parameters.entrySet().toArray(), start, end);
        return result;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        long start = System.currentTimeMillis();
        int result = this.stmt.executeUpdate(sql, autoGeneratedKeys);
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, sql, this.parameters.entrySet().toArray(), start, end);
        return result;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        long start = System.currentTimeMillis();
        int result = this.stmt.executeUpdate(sql, columnIndexes);
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, sql, this.parameters.entrySet().toArray(), start, end);
        return result;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        long start = System.currentTimeMillis();
        int result = this.stmt.executeUpdate(sql, columnNames);
        long end = System.currentTimeMillis();
        ProxyConnection.printSQL(this.stmt, sql, this.parameters.entrySet().toArray(), start, end);
        return result;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.stmt.getConnection();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.stmt.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.stmt.getFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.stmt.getGeneratedKeys();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.stmt.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.stmt.getMaxRows();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.stmt.getMetaData();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.stmt.getMoreResults();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.stmt.getMoreResults(current);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.stmt.getParameterMetaData();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.stmt.getQueryTimeout();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.stmt.getResultSet();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.stmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.stmt.getResultSetHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.stmt.getUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.stmt.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.stmt.isClosed();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.stmt.isCloseOnCompletion();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.stmt.isPoolable();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.stmt.isWrapperFor(iface);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.parameters.put(parameterIndex, x);
        this.stmt.setArray(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.parameters.put(parameterIndex, x);
        this.stmt.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setBlob(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.parameters.put(parameterIndex, x);
        this.stmt.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.parameters.put(parameterIndex, x);
        this.stmt.setByte(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setBytes(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setClob(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setClob(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.stmt.setCursorName(name);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.parameters.put(parameterIndex, x);
        this.stmt.setDate(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.parameters.put(parameterIndex, x);
        this.stmt.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.parameters.put(parameterIndex, x);
        this.stmt.setDouble(parameterIndex, x);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.stmt.setEscapeProcessing(enable);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.stmt.setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.stmt.setFetchSize(rows);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.parameters.put(parameterIndex, Float.valueOf(x));
        this.stmt.setFloat(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.parameters.put(parameterIndex, x);
        this.stmt.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.parameters.put(parameterIndex, x);
        this.stmt.setLong(parameterIndex, x);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.stmt.setMaxFieldSize(max);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.stmt.setMaxRows(max);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setNClob(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setNClob(parameterIndex, reader);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.parameters.put(parameterIndex, value);
        this.stmt.setNString(parameterIndex, value);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.parameters.put(parameterIndex, null);
        this.stmt.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.parameters.put(parameterIndex, null);
        this.stmt.setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.stmt.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.parameters.put(parameterIndex, x);
        this.stmt.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.parameters.put(parameterIndex, x);
        this.stmt.setObject(parameterIndex, (Object)targetSqlType, scaleOrLength);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.stmt.setPoolable(poolable);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.stmt.setQueryTimeout(seconds);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setRef(parameterIndex, x);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.parameters.put(parameterIndex, x);
        this.stmt.setRowId(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.parameters.put(parameterIndex, x);
        this.stmt.setShort(parameterIndex, x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.parameters.put(parameterIndex, x);
        this.stmt.setString(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.parameters.put(parameterIndex, x);
        this.stmt.setTime(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.parameters.put(parameterIndex, x);
        this.stmt.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.parameters.put(parameterIndex, x);
        this.stmt.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.parameters.put(parameterIndex, x);
        this.stmt.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.parameters.put(parameterIndex, "$" + parameterIndex);
        this.stmt.setURL(parameterIndex, x);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.stmt.unwrap(iface);
    }
}

