/*
 * Decompiled with CFR 0.152.
 */
package john.walker;

import com.alibaba.druid.util.JMXUtils;
import java.io.PrintWriter;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import john.walker.Monitor;
import john.walker.ProxyCallableStatement;
import john.walker.ProxyPreparedStatement;
import john.walker.ProxyStatement;
import john.walker.config.XmlFileLoader;
import john.walker.filter.ConfigurableStackTraceFilter;
import john.walker.filter.DefaultStackTraceFilter;
import john.walker.filter.StackTraceFilter;
import john.walker.jmx.ProxyStatManager;
import john.walker.log.LogFactory;

public class ProxyConnection
implements Connection {
    private static List<StackTraceFilter> stackTraceFilters = new ArrayList<StackTraceFilter>(3);
    private static StackTraceFilter defaultStackTraceFilter = new DefaultStackTraceFilter();
    private Connection con = null;
    private StackTraceElement[] connectionStackTrace;

    public ProxyConnection(Connection con) {
        this.con = con;
        this.connectionStackTrace = Thread.currentThread().getStackTrace();
        Monitor.getMonitor().addConnection(this);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.con.abort(executor);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.con.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.con.close();
        Monitor.getMonitor().removeConnection(this);
    }

    @Override
    public void commit() throws SQLException {
        this.con.commit();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.con.createArrayOf(typeName, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.con.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.con.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.con.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.con.createSQLXML();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new ProxyStatement(this.con.createStatement());
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ProxyStatement(this.con.createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ProxyStatement(this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.con.createStruct(typeName, attributes);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.con.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.con.getCatalog();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.con.getClientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.con.getClientInfo(name);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.con.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.con.getMetaData();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.con.getNetworkTimeout();
    }

    @Override
    public String getSchema() throws SQLException {
        return this.con.getSchema();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.con.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.con.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.con.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.con.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.con.isReadOnly();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.con.isValid(timeout);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.con.isWrapperFor(iface);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.con.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return new ProxyCallableStatement(this.con.prepareCall(sql), sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ProxyCallableStatement(this.con.prepareCall(sql, resultSetType, resultSetConcurrency), sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ProxyCallableStatement(this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new ProxyPreparedStatement(this.con.prepareStatement(sql), sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new ProxyPreparedStatement(this.con.prepareStatement(sql, autoGeneratedKeys), sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ProxyPreparedStatement(this.con.prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ProxyPreparedStatement(this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new ProxyPreparedStatement(this.con.prepareStatement(sql, columnIndexes), sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new ProxyPreparedStatement(this.con.prepareStatement(sql, columnNames), sql);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.con.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.con.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.con.rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.con.setAutoCommit(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.con.setCatalog(catalog);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.con.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.con.setClientInfo(name, value);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.con.setHoldability(holdability);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.con.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.con.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.con.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.con.setSavepoint(name);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.con.setSchema(schema);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.con.setTransactionIsolation(level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.con.setTypeMap(map);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.con.unwrap(iface);
    }

    public static synchronized void printSQL(Statement stmt, String sql, Object[] parameters, long start, long end) {
        if (!ProxyStatManager.getInstance().isPrintLog()) {
            return;
        }
        if (!XmlFileLoader.sqlMonitor()) {
            return;
        }
        long time = end - start;
        if (time < XmlFileLoader.sqlMonitorTime()) {
            return;
        }
        Class<?> c = stmt.getClass();
        boolean isOriginalStmt = false;
        do {
            if (!c.getName().startsWith("com.mysql.jdbc") && !c.getName().startsWith("org.apache.derby") && !c.getName().startsWith("oracle.jdbc")) continue;
            isOriginalStmt = true;
            break;
        } while ((c = c.getSuperclass()).getSuperclass() != null);
        if (isOriginalStmt) {
            LogFactory.getLogger().log("SQL\u4ee3\u7406\uff1a " + sql);
            if (parameters != null && parameters.length > 0) {
                LogFactory.getLogger().log("SQL\u53c2\u6570\uff1a " + Arrays.toString(parameters));
            }
            String format = "";
            format = time < 1000L ? time + "\u6beb\u79d2" : (time < 60000L ? (double)time / 1000.0 + "\u79d2" : (time < 3600000L ? (double)time / 60000.0 + "\u5206\u949f" : (double)time / 3600000.0 + "\u5c0f\u65f6"));
            LogFactory.getLogger().log("SQL\u8017\u65f6\uff1a " + format);
            if (XmlFileLoader.sqlMonitorStack()) {
                LogFactory.getLogger().log("\u8c03\u7528\u6808\u5982\u4e0b\uff1a");
                ProxyConnection.printStackTrace();
            }
            LogFactory.getLogger().newLine();
        }
    }

    public static void printSQL(Statement stmt, String sql, long start, long end) {
        ProxyConnection.printSQL(stmt, sql, null, start, end);
    }

    public static void printStackTrace() {
        StackTraceElement[] elements;
        for (StackTraceElement e : elements = Thread.currentThread().getStackTrace()) {
            boolean accpet = true;
            for (StackTraceFilter filter : stackTraceFilters) {
                if (filter.accpet(e.getClassName(), e.getMethodName())) continue;
                accpet = false;
                break;
            }
            if (!accpet) continue;
            LogFactory.getLogger().log(e.getClassName() + "." + e.getMethodName() + ":" + e.getLineNumber());
        }
    }

    public static List<StackTraceFilter> getStackTraceFilters() {
        return stackTraceFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStackTraceFilter(StackTraceFilter stackTraceFilter) {
        List<StackTraceFilter> list = stackTraceFilters;
        synchronized (list) {
            stackTraceFilters.add(stackTraceFilter);
        }
    }

    public static void addStackTraceFilterWords(List<String> stackTraceFilterWords) {
        if (stackTraceFilterWords != null) {
            ProxyConnection.addStackTraceFilter(new ConfigurableStackTraceFilter(stackTraceFilterWords));
        }
    }

    public void printConnectionStackTrace(PrintWriter out) {
        if (this.connectionStackTrace != null) {
            for (StackTraceElement e : this.connectionStackTrace) {
                if (!defaultStackTraceFilter.accpet(e.getClassName(), e.getMethodName())) continue;
                out.println(e.toString());
            }
        }
    }

    static {
        ProxyConnection.addStackTraceFilter(defaultStackTraceFilter);
        ProxyConnection.addStackTraceFilter(new ConfigurableStackTraceFilter(XmlFileLoader.loadFilterWords()));
        XmlFileLoader.loadLoggers();
        JMXUtils.register((String)"john.walker:type=ProxyStat", (Object)ProxyStatManager.getInstance());
    }
}

