/*
 * Decompiled with CFR 0.152.
 */
package john.walker;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.IdentityHashMap;
import john.walker.ProxyConnection;

public class Monitor {
    private static Monitor monitor;
    private IdentityHashMap<ProxyConnection, Object> notClosedConnections = new IdentityHashMap();
    protected static final Object PRESENT;

    private Monitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Monitor getMonitor() {
        if (monitor != null) return monitor;
        Class<Monitor> clazz = Monitor.class;
        synchronized (Monitor.class) {
            if (monitor != null) return monitor;
            monitor = new Monitor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return monitor;
        }
    }

    public void removeConnection(ProxyConnection con) {
        if (con != null) {
            Monitor.getMonitor().notClosedConnections.remove(con);
        }
    }

    public void addConnection(ProxyConnection con) {
        if (con != null) {
            Monitor.getMonitor().notClosedConnections.put(con, PRESENT);
        }
    }

    public void printStackTrace(PrintWriter out) {
        HashSet<ProxyConnection> sets = new HashSet<ProxyConnection>(this.notClosedConnections.keySet());
        out.println("\u5f53\u524d\u672a\u5173\u95ed\u7684\u6570\u636e\u5e93\u8fde\u63a5\u603b\u6570 " + sets.size() + "\uff0c\u8c03\u7528\u6808\u5982\u4e0b\uff1a ");
        out.println();
        int i = 1;
        for (ProxyConnection con : sets) {
            out.println("\u7b2c " + i++ + " \u4e2a\u8fde\u63a5\uff1a");
            con.printConnectionStackTrace(out);
            out.println();
        }
    }

    static {
        PRESENT = new Object();
    }
}

