package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.InterestGoodsProvide.F_INTEREST_GOODS_ID;
import static com.thebeastshop.scm.po.InterestGoodsSku.F_SKU_CODE;

import java.util.List;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.InterestGoodsSku;
import com.thebeastshop.scm.vo.interest.InterestGoodsSkuVO;

@DaoConfig(table = "interest_goods_sku")
public class InterestGoodsSkuDao extends BaseDao<InterestGoodsSku>{
	
	@Autowired
	public InterestGoodsSkuDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<InterestGoodsSku> byInterestGoodsId(Integer interestGoodsId) {
		return super.selectList(new WhereBuilder(F_INTEREST_GOODS_ID, interestGoodsId).orderAsc("id"));
	}
	
	public InterestGoodsSku getInterestGoodsSku(Integer interestGoodsId, String skuCode) {
		return super.selectOne(new WhereBuilder().eq(F_INTEREST_GOODS_ID, interestGoodsId).eq(F_SKU_CODE,skuCode));
	}
	
	public InterestGoodsSku getInStockByInterestGoodsId(Integer interestGoodsId) {
		return super.selectOne("getInStockByInterestId", interestGoodsId);
	}
	
	public Integer sumQuantityByInterestId(Integer interestGoodsId) {
		return super.selectOne("sumQuantityByInterestId", interestGoodsId);
	}
	
	public int deleteByInterestGoodsId(int interestGoodsId) {
		return super.delete(new WhereBuilder(F_INTEREST_GOODS_ID, interestGoodsId));
	}
	
	/**
	 * 添加商品权益 领取数
	 */
	public boolean addReceiveQuantity(Integer id){
		return super.update("addReceiveQuantity", id) == 1;
	}
	
	/** 
	 * 减少商品权益 领取数量
	 */
	public boolean reduceReceiveQuantity(Integer id) {
		return super.update("reduceReceiveQuantity", id) == 1;
	}
	
	/**
	 * 更新兑取数量
	 */
	public boolean updateCash(List<InterestGoodsSkuVO> interestGoodsSkuVOList) {
		int result = 0;
		for (InterestGoodsSkuVO interestGoodsSkuVo: interestGoodsSkuVOList) {
			result += super.update("updateCashQuantity",interestGoodsSkuVo.toMap());
		}
		return result == interestGoodsSkuVOList.size();
	}
	
	/**
	 * 减少兑换数量
	 */
	public boolean reduceCashQuantity(List<InterestGoodsSkuVO> interestGoodsSkuVOList) {
		int result = 0;
		for (InterestGoodsSkuVO interestGoodsSkuVo: interestGoodsSkuVOList) {
			result += super.update("reduceCashQuantity",interestGoodsSkuVo.toMap());
		}
		return result == interestGoodsSkuVOList.size();
	}

}