package com.thebeastshop.scm.dao;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.thebeastshop.scm.po.InterestFree.*;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.InterestFree;
import com.thebeastshop.scm.vo.interest.InterestFreeCond;
import com.thebeastshop.scm.vo.interest.InterestFreeVO;

/**
 * 免邮权益Dao 
 * @Class Name InterestFreeDao
 * @Author Xiang.Gao
 * @Create In 2017-3-22
 */
@DaoConfig(table = "interest_free")
public class InterestFreeDao extends BaseDao<InterestFree>{

	@Autowired
	public InterestFreeDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<InterestFreeVO> queryList(InterestFreeCond cond) {
		return super.selectList("selectInterestFree", cond.toMap());
	}
	
	/**
	 * 查询用户适用权益
	 * @Methods Name selectByMemberId
	 * @Create In 2017-3-31 By Xiang.Gao
	 */
	public List<InterestFreeVO> selectByMemberId(Integer memberId, 
			String accessWay, Integer crossBorderFlag) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("memberId", memberId);
		map.put("accessWay", accessWay);
		map.put("crossBorderFlag", crossBorderFlag);
		return super.selectList("selectByMemberId", map);
	}
	
	/**
	 * 查询用户已领取未使用的免邮权益
	 * @Methods Name selectAllValid
	 * @Create In 2017-4-21 By Xiang.Gao
	 */
	public List<InterestFreeVO> selectAllMemberInterestFree() {
		Map<String, Object> map = new HashMap<String, Object>();
		return super.selectList("selectByMemberId", map);
	}
	
	/**
	 * 查询海淘免邮权益(针对老虎大象等级)
	 * @Methods Name selectCrossBorderInterestFree
	 * @Create In 2017-4-23 By Xiang.Gao
	 */
	public List<InterestFreeVO> selectCrossBorderInterestFree(Integer memberId) {
		Map<String, Object> map = new HashMap<String, Object>();
		if(memberId != null) {
			map.put("memberId", memberId);
		}
		return super.selectList("selectByMemberId", map);
	}
	
	/**
	 * 查询权益商品关系是否存在
	 * @Methods Name selectInterestProduct
	 * @Create In 2017-3-31 By Xiang.Gao
	 */
	public boolean selectRelation(Integer interestFreeId, 
			List<Integer> bingdingIds, Integer isExclusion) {
		Map<String ,Object> map = new HashMap<String, Object>();
		map.put("interestFreeId", interestFreeId);
		map.put("bingdingIds", bingdingIds);
		map.put("isExclusion", isExclusion);
		int result = super.selectOne("selectRelation", map);
		return result > 0;
	}
	
	public InterestFreeVO selectByProvideId(Integer provideId) {
		return super.selectOne("selectByProvideId", provideId);
	}
	
	/**
	 * 更新免邮权益领取数(乐观锁)
	 * @Methods Name updateReceived
	 * @Create In 2017-3-23 By Xiang.Gao
	 */
	public int updateReceived(Integer id, Integer receivedTotal) {
		return super.update(new UpdateBuilder().updateIncr(F_RECEIVED_TOTAL)
				.whereEq(F_RECEIVED_TOTAL, receivedTotal).whereEq(F_ID, id));
	}
	
	/**
	 * 查询快要到期的免邮权益
	 * @Methods Name getPreExpiration
	 * @Create In 2017-4-21 By Xiang.Gao
	 */
	public List<InterestFreeVO> getPreExpiration(Integer day) {
		return super.selectList("getPreExpiration", day);
	}

}
