package com.thebeastshop.scm.dao;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.scm.es.*;
import com.thebeastshop.scm.po.CustomizeElement;
import com.thebeastshop.scm.po.CustomizeImage;
import com.thebeastshop.scm.po.SkuCombination;
import com.thebeastshop.scm.po.SkuCustomization;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.support.ManagedProperties;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-11-15
 */
@DaoConfig(table = "t_pcs_sku_customization")
public class SkuCustomizationDao extends BaseDao<SkuCustomization> {

    @Autowired
    public SkuCustomizationDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<PsSkuCustomizationVO> findBySkuCode(String skuCode) {
        List<PsSkuCustomizationVO> voList = new ArrayList<>();
        Map<String, Object> params = new HashMap<>();
        params.put("skuCode", skuCode);
        List<SkuCustomization> list = super.selectList("findSkuCustomizationByIdsfindBySkuCode", params);
        for (SkuCustomization skuCustomization : list) {
            voList.add(new PsSkuCustomizationVO(skuCustomization));
        }
        return voList;
    }

//    public List<PsCustomizeElementVO> findCustomizeElementList(String skuCode) {
//        List<PsCustomizeElementVO> voList = new ArrayList<>();
//        Map<String, Object> params = new HashMap<>();
//        params.put("skuCode", skuCode);
//        List<CustomizeElement> list =  super.selectList("findCustomizeElementList", params);
//        for (CustomizeElement element : list) {
//            voList.add(new PsCustomizeElementVO(element));
//        }
//        return voList;
//    }

    public List<PsCustomizeElementVO> findCustomizeElementList(String skuCode,Integer elementType,String positionIcon) {
        Map<String, Object> params = new HashMap<>();
        params.put("skuCode", skuCode);
        params.put("elementType", elementType);
        params.put("positionIcon", positionIcon);
        List<PsCustomizeElementVO> list =  super.selectList("findCustomizeElementList", params);
        for(PsCustomizeElementVO vo:list){
            Integer type = vo.getElementType();
            List<PsCustomizeColorVO> colorVOs = new ArrayList<PsCustomizeColorVO>();
            String color = vo.getColor();
            List<List<String>> ListObj = JSON.parseObject(color, List.class);
            if(CollectionUtils.isNotEmpty(ListObj)){
                for(List<String> listVO:ListObj){
                    PsCustomizeColorVO colorVO = new PsCustomizeColorVO();
                    colorVO.setColorName(listVO.get(0));
                    colorVO.setColorValue(listVO.get(1));
                    colorVOs.add(colorVO);
                }
            }
            vo.setColorList(colorVOs);
//            if(type != null && "2".equals(type.toString())){
//                String supportType =  vo.getSupportType();
//                PsSupportTypeVO supportTypeVO = new PsSupportTypeVO();
//                if(supportType.contains("1")){
//                    supportTypeVO.setLetter("1");
//                }
//                if(supportType.contains("2")){
//                    supportTypeVO.setNumber("1");
//                }
//                if(supportType.contains("3")){
//                    supportTypeVO.setExpression("1");
//                }
//                vo.setSupportTypeVO(supportTypeVO);
//            }
        }
        return list;
    }

    public List<PsCustomizeImageVO> findCustomizeImageList(String skuCode) {
        Map<String, Object> params = new HashMap<>();
        params.put("skuCode", skuCode);
        List<PsCustomizeImageVO> list =  super.selectList("findCustomizeImageList", params);
        if (CollectionUtils.isNotEmpty(list)) {
            for (PsCustomizeImageVO vo : list) {
                String attr = vo.getAttr();
                List<List> listObj = JSON.parseObject(attr, List.class);
                vo.setAttrs(listObj);
            }
        }
        return list;
    }

}
