package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.InterestFreeProvide.F_INTEREST_FREE_ID;
import static com.thebeastshop.scm.po.InterestFreeProvide.F_MEMBER_ID;
import static com.thebeastshop.scm.po.InterestFreeProvide.F_UPDATE_TIME;
import static com.thebeastshop.scm.po.InterestFreeProvide.F_USED_NUM;
import static pers.richard.ormybatis.domain.po.IdPo.F_ID;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.InterestFreeProvide;
import com.thebeastshop.scm.vo.interest.InterestFreeProvideVO;

@DaoConfig(table = "interest_free_provide")
public class InterestFreeProvideDao extends BaseDao<InterestFreeProvide>{

	@Autowired
	public InterestFreeProvideDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<InterestFreeProvideVO> selectProvideRecord(Integer interestFreeId) {
		return super.selectList("queryByInterestFreeId", interestFreeId);
	}
	
	public InterestFreeProvide selectBymember(Integer provideId, Integer memberId) {
		return super.selectOne(new WhereBuilder().eq(F_ID, provideId).eq(F_MEMBER_ID, memberId).gt(F_USED_NUM, 0));
	}
	
	public int countReceive(Integer interestFreeId) {
		return super.count(new WhereBuilder().eq(F_INTEREST_FREE_ID, interestFreeId));
	}
	
	public int countReceiveByMember(Integer interestFreeId,Integer memberId) {
		return super.count(new WhereBuilder().eq(F_INTEREST_FREE_ID, interestFreeId).eq(F_MEMBER_ID, memberId));
	}
	
	/**
	 * 更新权益使用数量
	 * @Methods Name updateUsedNum
	 * @Create In 2017-3-23 By Xiang.Gao
	 */
	public int updateUsedNum(Integer provideId, Integer usedNum) {
		UpdateBuilder update = new UpdateBuilder();
		update.updateIncr(F_USED_NUM);
		update.updateEq(F_UPDATE_TIME, new Date());
		WhereBuilder where = new WhereBuilder();
		where.eq(F_ID, provideId).eq(F_USED_NUM,usedNum);
		update.setWhereBuilder(where);
		return super.update(update);
	}
	
	/**
	 * 返还权益使用数量
	 * @Methods Name backInterestFree
	 * @Create In 2017-3-24 By Xiang.Gao
	 */
	public int backInterestFree(Integer provideId) {
		return super.update("updateBackUsedNum", provideId);
	}
	
	/**
	 * 查询权益最大使用数
	 * @Methods Name selectMaxUsedNum
	 * @Create In 2017-3-23 By Xiang.Gao
	 */
	public int selectMaxUsedNum(Integer interestFreeId) {
		return super.selectOne("selectMaxUsedNum", interestFreeId);
	}
	
	/** 查询单个用户最大使用数
	 * @Methods Name selectSignMaxReceiveNum
	 * @Create In 2017-3-23 By Xiang.Gao
	 */
	public int selectSignMaxReceiveNum(Integer interestFreeId) {
		return super.selectOne("selectSignMaxReceiveNum",interestFreeId);
	}
	
	/**
	 * 查询当月领取数(针对老虎大象每月免邮)
	 * @Methods Name checkReceiveCurMonth
	 * @Create In 2017-4-20 By Xiang.Gao
	 */
	public int checkReceiveCurMonth(Integer interestFreeId,Integer memberId) {
		Map<String, Integer> map = new HashMap<String, Integer>();
		map.put("interestFreeId", interestFreeId);
		map.put("memberId", memberId);
		return super.selectOne("checkReceiveCurMonth",map);
	}

}
