/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.InterestMember;
import com.thebeastshop.scm.vo.interest.InterestSkuVO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;
import pers.richard.ormybatis.domain.po.IdPo;

@DaoConfig(table="interest_member")
public class InterestMemberDao
extends BaseDao<InterestMember> {
    @Autowired
    public InterestMemberDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public void save(Integer memberId, Integer interestId, Integer interestSkuId) {
        InterestMember interestMember = new InterestMember();
        interestMember.setMemberId(memberId);
        interestMember.setInterestId(interestId);
        interestMember.setInterestSkuId(interestSkuId);
        interestMember.setIsCash(Integer.valueOf(0));
        interestMember.setCreateTime(new Date());
        super.insert((IdPo)interestMember);
    }

    public void changeInterestSkuId(Integer memberId, Integer sourceInterestSkuId, Integer destInterestSkuId) {
        UpdateBuilder ub = new UpdateBuilder().updateEq("interest_sku_id", (Object)destInterestSkuId).updateEq("update_time", (Object)new Date()).whereEq("member_id", (Object)memberId).whereEq("interest_sku_id", (Object)sourceInterestSkuId).whereEq("is_cash", (Object)0);
        super.update(ub);
    }

    public boolean updateCash(Integer memberId, List<InterestSkuVO> interestSkuVOList) {
        int updateline = 0;
        int cashCount = 0;
        for (InterestSkuVO interestSkuVo : interestSkuVOList) {
            Map param = interestSkuVo.toMap();
            param.put("memberId", memberId);
            cashCount += interestSkuVo.getCashQuantity().intValue();
            updateline += super.update("updateCash", (Object)param);
        }
        return updateline == cashCount;
    }

    public Map<Integer, Integer> getCashQuantity(List<Integer> interestSkuIds) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        WhereBuilder whereBuilder = null;
        for (Integer interestSkuId : interestSkuIds) {
            whereBuilder = new WhereBuilder().eq("is_cash", (Object)1).eq("interest_sku_id", (Object)interestSkuId);
            map.put(interestSkuId, super.count(whereBuilder));
        }
        return map;
    }

    public List<InterestMember> queryInterestMember(Integer interestId) {
        return super.selectList(new WhereBuilder().eq("interest_id", (Object)interestId).eq("is_cash", (Object)0));
    }
}

