package com.thebeastshop.scm.dao;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.LotteryActivityAward;
import com.thebeastshop.scm.po.LotteryActivityPrizeRecord;
import com.thebeastshop.scm.vo.lottery.LotteryActivityRecordVO;

@DaoConfig(table = "lottery_activity_prize_record")
public class LotteryActivityPrizeRecordDao extends BaseDao<LotteryActivityPrizeRecord>{
	
	@Autowired
	public LotteryActivityPrizeRecordDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 保存投资记录按奖项
	 * @param memberId
	 * @param lotteryActivityId 
	 * @param lotteryActivityAward 奖项记录
	 * @return 主键ID
	 */
	public LotteryActivityPrizeRecord save(Integer memberId, Integer lotteryActivityId, LotteryActivityAward lotteryActivityAward, String sysId) {
		LotteryActivityPrizeRecord lotteryActivityPrizeRecord = new LotteryActivityPrizeRecord();
		lotteryActivityPrizeRecord.setMemberId(memberId);
		lotteryActivityPrizeRecord.setLotteryActivityId(lotteryActivityId);
		lotteryActivityPrizeRecord.setSysId(sysId);
		lotteryActivityPrizeRecord.setCreateTime(new Date());
		if (lotteryActivityAward == null) {
			lotteryActivityPrizeRecord.setIsWin(0);
			log.info("用户memberId:{} 没中奖", memberId);
		} else {
			lotteryActivityPrizeRecord.setIsWin(1);
			lotteryActivityPrizeRecord.setLotteryActivityAwardId(lotteryActivityAward.getId());
			log.info("用户memberId:{} 中奖了", memberId);
		}
		super.insert(lotteryActivityPrizeRecord);
		return lotteryActivityPrizeRecord;
	} 
	
	/**
	 * 今天抽过奖几次
	 * @param memberId
	 * @param lotteryActivityId 
	 * @return 
	 */
	public Integer getDayCountByMemberIdAndLotteryActivityId(Integer memberId, Integer lotteryActivityId) {
		Map params = new HashMap();
		params.put("memberId", memberId);
		params.put("lotteryActivityId", lotteryActivityId);
		params.put("nowTime", DateFormatUtils.format(new Date(), "yyyy-MM-dd"));
		return super.selectOne("getDayCountByMemberIdAndLotteryActivityId", params);
	}
	
	public List<Map> winListByAwardId(Integer awardId) {
		return super.selectList("winListByAwardId", awardId);
	}
	
	public Integer bySysId(Integer memberId, Integer lotteryActivityId, String sysId) {
		Map params = new HashMap();
		params.put("memberId", memberId);
		params.put("lotteryActivityId", lotteryActivityId);
		params.put("sysId", sysId.trim());
		return super.selectOne("bySysId", params);
	}
	
	/**
	 * 查询中奖的记录
	 * @param memberId
	 * @param lotteryActivityId
	 * @return
	 */
	public List<LotteryActivityRecordVO> getWinByMemberIdAndLotteryActivityId(Integer memberId, Integer lotteryActivityId) {
		Map params = new HashMap();
		params.put("isWin", 1);
		params.put("memberId", memberId);
		params.put("lotteryActivityId", lotteryActivityId);
		return super.selectList("getLotteryActivityRecordVO", params);
	}
	/**
	 * 查询最近中奖的记录
	 * @return
	 */
	public List<LotteryActivityRecordVO> lastNewest(Integer limit) {
		Map params = new HashMap();
		params.put("limitSize", limit);
		return super.selectList("getLotteryActivityRecordVO", params);
	}
	
	/**
	 * 中奖信息按中奖记录ID
	 */
	public LotteryActivityRecordVO getLotteryActivityRecordVOById(Integer lotteryActivityPrizeRecordId) {
		Map params = new HashMap();
		params.put("id", lotteryActivityPrizeRecordId);
		return super.selectOne("getLotteryActivityRecordVO", params);
	}
}