package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.InterestGoodsProvide.F_IS_CASH;
import static com.thebeastshop.scm.po.InterestGoodsProvide.F_INTEREST_GOODS_SKU_ID;
import static com.thebeastshop.scm.po.InterestGoodsProvide.F_INTEREST_GOODS_ID;
import static com.thebeastshop.scm.po.InterestGoodsProvide.F_MEMBER_ID;
import static com.thebeastshop.scm.po.InterestGoodsProvide.F_UPDATE_TIME;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.cond.InterestGoodsCond;
import com.thebeastshop.scm.po.InterestGoodsProvide;
import com.thebeastshop.scm.vo.interest.InterestGoodsProvideVO;
import com.thebeastshop.scm.vo.interest.InterestGoodsSkuVO;

@DaoConfig(table = "interest_goods_provide")
public class InterestGoodsProvideDao extends BaseDao<InterestGoodsProvide>{
	
	@Autowired
	public InterestGoodsProvideDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}

	public int save(Integer memberId, Integer interestGoodsId, Integer interestGoodsSkuId) {
		InterestGoodsProvide interestGoodsProvide = new InterestGoodsProvide();
		interestGoodsProvide.setMemberId(memberId);
		interestGoodsProvide.setInterestGoodsId(interestGoodsId);
		interestGoodsProvide.setInterestGoodsSkuId(interestGoodsSkuId);
		interestGoodsProvide.setIsCash(0);
		interestGoodsProvide.setCreateTime(new Date());
		return super.insert(interestGoodsProvide);
	}

	/**
	 * 设置为已兑取
	 * @param memberId
	 * @param interestGoodsSkuVOList
	 */
	public boolean updateCash(Integer memberId, List<InterestGoodsSkuVO> interestGoodsSkuVOList) {
		int updateline = 0;
		int cashCount = 0;
		for (InterestGoodsSkuVO interestGoodsSkuVo : interestGoodsSkuVOList) {
			Map<String, Object> param = interestGoodsSkuVo.toMap();
			param.put("memberId", memberId);
			cashCount += interestGoodsSkuVo.getCashQuantity();
			updateline += super.update("updateCash", param);
		}
		return updateline == cashCount;
	}
	
	/**
	 * 设置为未兑取
	 * @Methods Name resetCash
	 * @Create In 2017-5-9 By Xiang.Gao
	 */
	public boolean resetCash(Integer memberId, List<InterestGoodsSkuVO> interestGoodsSkuVOList) {
		int updateline = 0;
		int resetCount = 0;
		for (InterestGoodsSkuVO interestGoodsSkuVo : interestGoodsSkuVOList) {
			Map<String, Object> param = interestGoodsSkuVo.toMap();
			param.put("memberId", memberId);
			resetCount += interestGoodsSkuVo.getCashQuantity();
			updateline += super.update("resetCash", param);
		}
		return updateline == resetCount;
	}
	
	/**
	 * 更改还没兑取的权益sku
	 * @param memberId 
	 * @param sourceInterestGoodsSkuId
	 * @param destInterestGoodsSkuId
	 */
	public int changeInterestGoodsSkuId(Integer memberId, Integer sourceInterestGoodsSkuId, Integer destInterestGoodsSkuId) {
		UpdateBuilder ub = new UpdateBuilder()
			.updateEq(F_INTEREST_GOODS_SKU_ID, destInterestGoodsSkuId).updateEq(F_UPDATE_TIME, new Date())
			.whereEq(F_MEMBER_ID, memberId).whereEq(F_INTEREST_GOODS_SKU_ID, sourceInterestGoodsSkuId).whereEq(F_IS_CASH, 0);
		return super.update(ub);
	}

	
	/**
	 * 获取已兑取的数量
	 * @Methods Name getCashQuantity
	 * @Create In 2017-2-27 By Xiang.Gao
	 * @param interestGoodsSkuId
	 */
	public Map<Integer, Integer> getCashQuantity(List<Integer> interestGoodsSkuIds) {
		Map<Integer, Integer> map = new HashMap<Integer, Integer>();
		WhereBuilder whereBuilder = null;
		for (Integer interestGoodsSkuId : interestGoodsSkuIds) {
			 whereBuilder = new WhereBuilder().eq(F_IS_CASH, 1)
			.eq(F_INTEREST_GOODS_SKU_ID, interestGoodsSkuId);
			 map.put(interestGoodsSkuId,super.count(whereBuilder));
		}
		return map;
	}
	
	/**
	 * 查询未兑换的商品权益
	 * @Methods Name getUnCashQuantity
	 * @Create In 2017-5-9 By Xiang.Gao
	 */
	public int countCashQuantity(Integer memberId, Integer interestGoodsId, Integer interestGoodsSkuId,boolean isCash) {
		WhereBuilder whereBuilder = new WhereBuilder()
			.eq(F_MEMBER_ID, memberId).eq(F_INTEREST_GOODS_ID,interestGoodsId)
			.eq(F_INTEREST_GOODS_SKU_ID, interestGoodsSkuId).eq(F_IS_CASH, isCash ? 0 : 1);
		return super.count(whereBuilder);
	}
	
	/**
	 * 根据权益ID查询未使用的商品权益
	 * @Methods Name queryInterest
	 * @Create In 2017-4-20 By Xiang.Gao
	 */
	public List<InterestGoodsProvide> queryInterestGoodsProvide(Integer interestGoodsId) {
		return super.selectList(new WhereBuilder().eq(F_INTEREST_GOODS_ID, interestGoodsId).eq(F_IS_CASH,0));
	}
	
	/**
	 * 查询领取记录
	 * @Methods Name queryProvideRecord
	 * @Create In 2017-5-5 By Xiang.Gao
	 */
	public List<InterestGoodsProvideVO> queryProvideRecord(InterestGoodsCond cond) {
		return super.selectList("queryProvideRecord", cond.toMap());
	}
}