/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.InterestGoodsSku;
import com.thebeastshop.scm.vo.interest.InterestGoodsSkuVO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table="interest_goods_sku")
public class InterestGoodsSkuDao
extends BaseDao<InterestGoodsSku> {
    @Autowired
    public InterestGoodsSkuDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<InterestGoodsSku> byInterestGoodsId(Integer interestGoodsId) {
        return super.selectList(new WhereBuilder("interest_goods_id", (Object)interestGoodsId).orderAsc("id"));
    }

    public Integer sumQuantityByInterestId(Integer interestGoodsId) {
        return (Integer)super.selectOne("sumQuantityByInterestId", (Object)interestGoodsId);
    }

    public InterestGoodsSku getInStockByInterestGoodsId(Integer interestGoodsId) {
        return (InterestGoodsSku)super.selectOne("getInStockByInterestId", (Object)interestGoodsId);
    }

    public boolean addReceiveQuantity(Integer id, Integer version) {
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("id", id);
        param.put("version", version);
        return super.update("addReceiveQuantity", param) == 1;
    }

    public void addReceiveQuantity(Integer id) {
        UpdateBuilder ub = new UpdateBuilder().updateIncr("receive_quantity").updateEq("update_time", (Object)new Date()).whereEq("id", (Object)id);
        super.update(ub);
    }

    public boolean reduceReceiveQuantity(Integer id) {
        UpdateBuilder ub = new UpdateBuilder().updateIncr("receive_quantity", (Number)-1).updateIncr("version").updateEq("update_time", (Object)new Date()).whereQt("receive_quantity", (Object)0).whereEq("id", (Object)id);
        return super.update(ub) == 1;
    }

    public int deleteByInterestGoodsId(int interestGoodsId) {
        return super.delete(new WhereBuilder("interest_goods_id", (Object)interestGoodsId));
    }

    public boolean updateCash(List<InterestGoodsSkuVO> interestGoodsSkuVOList) {
        int result = 0;
        for (InterestGoodsSkuVO interestGoodsSkuVo : interestGoodsSkuVOList) {
            result += super.update("updateCashQuantity", (Object)interestGoodsSkuVo.toMap());
        }
        return result == interestGoodsSkuVOList.size();
    }
}

