/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.InterestGoodsProvide;
import com.thebeastshop.scm.vo.interest.InterestGoodsProvideVO;
import com.thebeastshop.scm.vo.interest.InterestGoodsSkuVO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;
import pers.richard.ormybatis.domain.po.IdPo;

@DaoConfig(table="interest_goods_provide")
public class InterestGoodsProvideDao
extends BaseDao<InterestGoodsProvide> {
    @Autowired
    public InterestGoodsProvideDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public void save(Integer memberId, Integer interestGoodsId, Integer interestGoodsSkuId) {
        InterestGoodsProvide interestGoodsProvide = new InterestGoodsProvide();
        interestGoodsProvide.setMemberId(memberId);
        interestGoodsProvide.setInterestGoodsId(interestGoodsId);
        interestGoodsProvide.setInterestGoodsSkuId(interestGoodsSkuId);
        interestGoodsProvide.setIsCash(Integer.valueOf(0));
        interestGoodsProvide.setCreateTime(new Date());
        super.insert((IdPo)interestGoodsProvide);
    }

    public void changeInterestGoodsSkuId(Integer memberId, Integer sourceInterestGoodsSkuId, Integer destInterestGoodsSkuId) {
        UpdateBuilder ub = new UpdateBuilder().updateEq("interest_goods_sku_id", (Object)destInterestGoodsSkuId).updateEq("update_time", (Object)new Date()).whereEq("member_id", (Object)memberId).whereEq("interest_goods_sku_id", (Object)sourceInterestGoodsSkuId).whereEq("is_cash", (Object)0);
        super.update(ub);
    }

    public boolean updateCash(Integer memberId, List<InterestGoodsSkuVO> interestGoodsSkuVOList) {
        int updateline = 0;
        int cashCount = 0;
        for (InterestGoodsSkuVO interestGoodsSkuVo : interestGoodsSkuVOList) {
            Map param = interestGoodsSkuVo.toMap();
            param.put("memberId", memberId);
            cashCount += interestGoodsSkuVo.getCashQuantity().intValue();
            updateline += super.update("updateCash", (Object)param);
        }
        return updateline == cashCount;
    }

    public Map<Integer, Integer> getCashQuantity(List<Integer> interestGoodsSkuIds) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        WhereBuilder whereBuilder = null;
        for (Integer interestGoodsSkuId : interestGoodsSkuIds) {
            whereBuilder = new WhereBuilder().eq("is_cash", (Object)1).eq("interest_goods_sku_id", (Object)interestGoodsSkuId);
            map.put(interestGoodsSkuId, super.count(whereBuilder));
        }
        return map;
    }

    public List<InterestGoodsProvide> queryInterestGoodsProvide(Integer interestGoodsId) {
        return super.selectList(new WhereBuilder().eq("interest_goods_id", (Object)interestGoodsId).eq("is_cash", (Object)0));
    }

    public List<InterestGoodsProvideVO> queryProvideRecord(Integer interestGoodsId) {
        return super.selectList("queryProvideRecord", (Object)interestGoodsId);
    }
}

