package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.InterestGoodsProvide.F_INTEREST_GOODS_ID;
import static com.thebeastshop.scm.po.InterestGoodsProvide.F_UPDATE_TIME;
import static com.thebeastshop.scm.po.InterestGoodsSku.F_RECEIVE_QUANTITY;
import static com.thebeastshop.scm.po.InterestGoodsSku.F_VERSION;
import static pers.richard.ormybatis.domain.po.IdPo.F_ID;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.InterestGoodsSku;
import com.thebeastshop.scm.vo.interest.InterestGoodsSkuVO;

@DaoConfig(table = "interest_goods_sku")
public class InterestGoodsSkuDao extends BaseDao<InterestGoodsSku>{
	
	@Autowired
	public InterestGoodsSkuDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<InterestGoodsSku> byInterestGoodsId(Integer interestGoodsId) {
		return super.selectList(new WhereBuilder("interest_goods_id", interestGoodsId).orderAsc("id"));
	}
	
	public Integer sumQuantityByInterestId(Integer interestGoodsId) {
		return super.selectOne("sumQuantityByInterestId", interestGoodsId);
	}
	
	/**
	 * 有库存的按权益ID
	 * @param interestId
	 * @return
	 */
	public InterestGoodsSku getInStockByInterestGoodsId(Integer interestGoodsId) {
		return super.selectOne("getInStockByInterestId", interestGoodsId);
	}
	
	/**
	 * 乐观锁增加领取数量
	 * @param id
	 * @param version
	 * @return 更新是否成功
	 */
	public boolean addReceiveQuantity(Integer id, Integer version){
		Map param = new HashMap();
		param.put("id", id);
		param.put("version", version);
		return super.update("addReceiveQuantity", param) == 1;
	}

	/**
	 * 增加领取数量
	 * @param sourceInterestSkuId
	 */
	public void addReceiveQuantity(Integer id) {
		UpdateBuilder ub = new UpdateBuilder()
			.updateIncr(F_RECEIVE_QUANTITY).updateEq(F_UPDATE_TIME, new Date())
			.whereEq(F_ID, id);
		super.update(ub);
	}
	
	/**
	 *  乐观锁减少领取数量
	 * @param id
	 * @return  更新是否成功
	 */
	public boolean reduceReceiveQuantity(Integer id) {
		UpdateBuilder ub = new UpdateBuilder()
			.updateIncr(F_RECEIVE_QUANTITY, -1).updateIncr(F_VERSION).updateEq(F_UPDATE_TIME, new Date())
			.whereQt(F_RECEIVE_QUANTITY, 0).whereEq(F_ID, id);
		return super.update(ub) == 1;
	}
	
	public int deleteByInterestGoodsId(int interestGoodsId) {
		return super.delete(new WhereBuilder(F_INTEREST_GOODS_ID, interestGoodsId));
	}
	
	/**
	 * 更新兑取数量
	 * @Methods Name updateCash
	 * @Create In 2017-3-1 By Xiang.Gao
	 * @param interestGoodsSkuVOList void
	 */
	public boolean updateCash(List<InterestGoodsSkuVO> interestGoodsSkuVOList) {
		int result = 0;
		for (InterestGoodsSkuVO interestGoodsSkuVo: interestGoodsSkuVOList) {
			result += super.update("updateCashQuantity",interestGoodsSkuVo.toMap());
		}
		return result == interestGoodsSkuVOList.size();
	}

}