package com.thebeastshop.scm.dao;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.cond.InterestGoodsCond;
import com.thebeastshop.scm.po.InterestGoods;

@DaoConfig(table = "interest_goods")
public class InterestGoodsDao extends BaseDao<InterestGoods>{
	
	@Autowired
	public InterestGoodsDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<Map> list(InterestGoodsCond cond) {
		return super.selectList("list", cond.toMap());
	}	
	
	/**
	 * 返回快失效或已失效并且状态未更新的权益记录
	 * @return
	 */
	public List<InterestGoods> getInterestByTime(Date date) {
		return super.selectList("getInterestByTime", date);
	}
	
	/**
	 * 批量更新状态
	 * @Methods Name batchUpdateStatus
	 * @Create In 2017-3-3 By Xiang.Gao
	 * @param interestGoodsIds
	 * @return Integer
	 */
	public Integer batchUpdateStatus(List<Integer> interestGoodsIds) {
		return super.update("batchUpdateStatus", interestGoodsIds);
	}
}
