package com.thebeastshop.scm.dao;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.thebeastshop.scm.po.SoPackageDeliveryInfo;
import com.thebeastshop.scm.vo.SoPackageDeliveryInfoVO;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table = "t_op_so_package_delivery_info")
public class SoPackageDeliveryInfoDao extends BaseDao<SoPackageDeliveryInfo>{
	
	@Autowired
	public SoPackageDeliveryInfoDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 根据包裹ID找到配送信息
	 * @param packageId
	 * @return
	 */
	public SoPackageDeliveryInfoVO findSoPackageDeliveryInfoVOByPackageId(Integer packageId){
		return super.selectOne("findSoPackageDeliveryInfoVOByPackageId",packageId);
	}
}