package com.thebeastshop.scm.dao;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.Interest;

@DaoConfig(table = "interest")
public class InterestDao extends BaseDao<Interest>{
	
	@Autowired
	public InterestDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<Map> list() {
		return super.selectList("list");
	}	
	
	/**
	 * 返回快失效或已失效并且状态未更新的权益记录Id
	 * @return
	 */
	public List<Integer> getIdByValidity(Date date) {
		return super.selectList("getIdByTime", date);
	}
	
	/**
	 * 批量更新状态
	 * @Methods Name batchUpdateStatus
	 * @Create In 2017-3-3 By Xiang.Gao
	 * @param interestIds
	 * @return Integer
	 */
	public Integer batchUpdateStatus(List<Integer> interestIds) {
		return super.update("batchUpdateStatus", interestIds);
	}
}
