package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.InterestMember.F_INTEREST_ID;
import static com.thebeastshop.scm.po.InterestMember.F_UPDATE_TIME;
import static com.thebeastshop.scm.po.InterestSku.F_RECEIVE_QUANTITY;
import static com.thebeastshop.scm.po.InterestSku.F_VERSION;
import static pers.richard.ormybatis.domain.po.IdPo.F_ID;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.InterestSku;
import com.thebeastshop.scm.vo.interest.InterestSkuVO;

@DaoConfig(table = "interest_sku")
public class InterestSkuDao extends BaseDao<InterestSku>{
	
	@Autowired
	public InterestSkuDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<InterestSku> byInterestId(Integer interestId) {
		return super.selectList(new WhereBuilder("interest_id", interestId).orderAsc("id"));
	}
	
	public Integer sumQuantityByInterestId(Integer interestId) {
		return super.selectOne("sumQuantityByInterestId", interestId);
	}
	
	/**
	 * 有库存的按权益ID
	 * @param interestId
	 * @return
	 */
	public InterestSku getInStockByInterestId(Integer interestId) {
		return super.selectOne("getInStockByInterestId", interestId);
	}
	
	/**
	 * 乐观锁增加领取数量
	 * @param id
	 * @param version
	 * @return 更新是否成功
	 */
	public boolean addReceiveQuantity(Integer id, Integer version){
		Map param = new HashMap();
		param.put("id", id);
		param.put("version", version);
		return super.update("addReceiveQuantity", param) == 1;
	}

	/**
	 * 增加领取数量
	 * @param sourceInterestSkuId
	 */
	public void addReceiveQuantity(Integer id) {
		UpdateBuilder ub = new UpdateBuilder()
			.updateIncr(F_RECEIVE_QUANTITY).updateEq(F_UPDATE_TIME, new Date())
			.whereEq(F_ID, id);
		super.update(ub);
	}
	
	/**
	 *  乐观锁减少领取数量
	 * @param id
	 * @return  更新是否成功
	 */
	public boolean reduceReceiveQuantity(Integer id) {
		UpdateBuilder ub = new UpdateBuilder()
			.updateIncr(F_RECEIVE_QUANTITY, -1).updateIncr(F_VERSION).updateEq(F_UPDATE_TIME, new Date())
			.whereQt(F_RECEIVE_QUANTITY, 0).whereEq(F_ID, id);
		return super.update(ub) == 1;
	}
	
	public int deleteByInterestId(int interestId) {
		return super.delete(new WhereBuilder(F_INTEREST_ID, interestId));
	}
	
	/**
	 * 更新兑取数量
	 * @Methods Name updateCash
	 * @Create In 2017-3-1 By Xiang.Gao
	 * @param interestSkuVOList void
	 */
	public boolean updateCash(List<InterestSkuVO> interestSkuVOList) {
		int result = 0;
		for (InterestSkuVO interestSkuVo: interestSkuVOList) {
			result += super.update("updateCashQuantity",interestSkuVo.toMap());
		}
		return result == interestSkuVOList.size();
	}

}