package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.InterestMember.F_INTEREST_ID;
import static com.thebeastshop.scm.po.InterestMember.F_INTEREST_SKU_ID;
import static com.thebeastshop.scm.po.InterestMember.F_IS_CASH;
import static com.thebeastshop.scm.po.InterestMember.F_MEMBER_ID;
import static com.thebeastshop.scm.po.InterestMember.F_UPDATE_TIME;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.InterestMember;
import com.thebeastshop.scm.vo.interest.InterestSkuVO;

@DaoConfig(table = "interest_member")
public class InterestMemberDao extends BaseDao<InterestMember>{
	
	@Autowired
	public InterestMemberDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}

	public void save(Integer memberId, Integer interestId, Integer interestSkuId) {
		InterestMember interestMember = new InterestMember();
		interestMember.setMemberId(memberId);
		interestMember.setInterestId(interestId);
		interestMember.setInterestSkuId(interestSkuId);
		interestMember.setIsCash(0);
		interestMember.setCreateTime(new Date());
		super.insert(interestMember);
	}

	/**
	 * 更改还没兑取的权益sku
	 * @param memberId 
	 * @param sourceInterestSkuId
	 * @param destInterestSkuId
	 */
	public void changeInterestSkuId(Integer memberId,	Integer sourceInterestSkuId, Integer destInterestSkuId) {
		UpdateBuilder ub = new UpdateBuilder()
			.updateEq(F_INTEREST_SKU_ID, destInterestSkuId).updateEq(F_UPDATE_TIME, new Date())
			.whereEq(F_MEMBER_ID, memberId).whereEq(F_INTEREST_SKU_ID, sourceInterestSkuId).whereEq(F_IS_CASH, 0);
		super.update(ub);
	}

	/**
	 * 设置为已兑取
	 * @param memberId
	 * @param interestSkuVOList
	 */
	public boolean updateCash(Integer memberId, List<InterestSkuVO> interestSkuVOList) {
		int updateline = 0;
		int cashCount = 0;
		for (InterestSkuVO interestSkuVo : interestSkuVOList) {
			Map<String, Object> param = interestSkuVo.toMap();
			param.put("memberId", memberId);
			cashCount += interestSkuVo.getCashQuantity();
			updateline += super.update("updateCash", param);
		}
		return updateline == cashCount;
	}
	
	/**
	 * 获取已兑取的数量
	 * @Methods Name getCashQuantity
	 * @Create In 2017-2-27 By Xiang.Gao
	 * @param interestSkuId
	 * @return Integer
	 */
	public Map<Integer, Integer> getCashQuantity(List<Integer> interestSkuIds) {
		Map<Integer, Integer> map = new HashMap<Integer, Integer>();
		WhereBuilder whereBuilder = null;
		for (Integer interestSkuId : interestSkuIds) {
			 whereBuilder = new WhereBuilder().eq(F_IS_CASH, 1)
			.eq(F_INTEREST_SKU_ID, interestSkuId);
			 map.put(interestSkuId,super.count(whereBuilder));
		}
		return map;
	}
	
	/**
	 * 根据权益ID与 查询InterestMember
	 * @Methods Name queryInterest
	 * @Create In 2017-4-20 By Xiang.Gao
	 */
	public List<InterestMember> queryInterestMember(Integer interestId) {
		return super.selectList(new WhereBuilder().eq(F_INTEREST_ID, interestId).eq(F_IS_CASH,0));
	}
}