package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.Member.*;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.thebeastshop.scm.po.Member;
import com.thebeastshop.scm.vo.MemberVO;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table = "t_op_member")
public class MemberDao extends BaseDao<Member>{
	
	@Autowired
	public MemberDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}

	/**
	 * 根据参数查询会员信息
	 * 
	 * @param params
	 * @return
	 */
	public List<MemberVO> queryMemberVOByParams(Map<String,Object> params){
		if(params == null || params.size() == 0){
			return null;
		}

		return super.selectList("queryMemberVOByParams", params);
	}

	/**
     * 根据会员编码查找可用积分
     *
     * @param memberCode
     * @return
     */
	public BigDecimal findAvailablePointByCode(String memberCode){
    	return super.selectOne("findAvailablePointByCode", memberCode);
    }

    /**
     * 根据会员编码查找过期积分   2016-02-01节点
     *
     * @param memberCode
     * @return
     */
	public BigDecimal findHistoryPointByCode(String memberCode, String expiredDate){
		Map<String,Object> params = new HashMap<String,Object>();
		params.put("memberCode", memberCode);
		params.put("expiredDate", expiredDate);
    	return super.selectOne("findHistoryPointByCode", params);
    }

	/**
	 * 根据手机号或者邮箱查询会员信息（会员搜索页面）
	 * 
	 * @param params
	 * @return
	 */
	public List<MemberVO> queryMemberVOByEmailOrMobile(String emailOrMobile){
		return super.selectList("queryMemberVOByEmailOrMobile", emailOrMobile);
	}
}