package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.SkuCategoryRelation;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import java.util.List;

/**
 * @author gongjun
 * @since 2016-11-17
 */
@DaoConfig(table = "t_pcs_sku_category_relation")
public class SkuCategoryRelationDao extends BaseDao<SkuCategoryRelation> {
    @Autowired
    public SkuCategoryRelationDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    /**
     * 获取指定类目下的商品编号
     * @param categoryIds
     * @return
     */
    public List<Integer> getProductIdsByCategoryIds(List<Integer> categoryIds) {
        return super.selectList("getProductIdsByCategoryIds", categoryIds);
    }

    /**
     * 获取指定类目下的SPV编号
     * @param categoryIds
     * @return
     */
    public List<Integer> getSpvIdsByCategoryIds(List<Integer> categoryIds) {
        return super.selectList("getSpvIdsByCategoryIds", categoryIds);
    }
}
