package com.thebeastshop.scm.dao;

import java.util.Date;
import java.util.List;

import static com.thebeastshop.scm.po.InterestMember.*; 

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.InterestMember;

@DaoConfig(table = "interest_member")
public class InterestMemberDao extends BaseDao<InterestMember>{
	
	@Autowired
	public InterestMemberDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}

	public void save(Integer memberId, Integer interestId, Integer interestSkuId) {
		InterestMember interestMember = new InterestMember();
		interestMember.setMemberId(memberId);
		interestMember.setInterestId(interestId);
		interestMember.setInterestSkuId(interestSkuId);
		interestMember.setIsCash(0);
		interestMember.setCreateTime(new Date());
		interestMember.setUpdateTime(new Date());
		super.insert(interestMember);
	}

	/**
	 * 更改还没兑取的权益sku
	 * @param memberId 
	 * @param sourceInterestSkuId
	 * @param destInterestSkuId
	 */
	public void changeInterestSkuId(Integer memberId,	Integer sourceInterestSkuId, Integer destInterestSkuId) {
		UpdateBuilder ub = new UpdateBuilder()
			.updateEq(F_INTEREST_SKU_ID, destInterestSkuId).updateEq(F_UPDATE_TIME, new Date())
			.whereEq(F_MEMBER_ID, memberId).whereEq(F_INTEREST_SKU_ID, sourceInterestSkuId).whereEq(F_IS_CASH, 0);
		super.update(ub);
	}

	/**
	 * 设置为已兑取
	 * @param memberId
	 * @param interestIdList
	 */
	public void updateCash(Number memberId, List<Integer> interestIdList) {
		for (Integer interestId : interestIdList) {
			UpdateBuilder ub = new UpdateBuilder()
				.updateIncr(F_IS_CASH, 1).updateEq(F_UPDATE_TIME, new Date())
				.whereEq(F_MEMBER_ID, memberId).whereEq(F_INTEREST_ID, interestId);
			super.update(ub);
		}
	}
	
}