/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.InterestSku;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table="interest_sku")
public class InterestSkuDao
extends BaseDao<InterestSku> {
    @Autowired
    public InterestSkuDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<InterestSku> byInterestId(Integer interestId) {
        return super.selectList(new WhereBuilder("interest_id", (Object)interestId).orderAsc("id"));
    }

    public Integer sumQuantityByInterestId(Integer interestId) {
        return (Integer)super.selectOne("sumQuantityByInterestId", (Object)interestId);
    }

    public InterestSku getInStockByInterestId(Integer interestId) {
        return (InterestSku)super.selectOne("getInStockByInterestId", (Object)interestId);
    }

    public boolean addReceiveQuantity(Integer id, Integer version) {
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("id", id);
        param.put("version", version);
        return super.update("addReceiveQuantity", param) == 1;
    }

    public void addReceiveQuantity(Integer id) {
        UpdateBuilder ub = new UpdateBuilder().updateIncr("receive_quantity").updateEq("update_time", (Object)new Date()).whereEq("id", (Object)id);
        super.update(ub);
    }

    public boolean reduceReceiveQuantity(Integer id) {
        UpdateBuilder ub = new UpdateBuilder().updateIncr("receive_quantity", (Number)-1).updateIncr("version").updateEq("update_time", (Object)new Date()).whereQt("receive_quantity", (Object)0).whereEq("id", (Object)id);
        return super.update(ub) == 1;
    }

    public void deleteByInterestId(int interestId) {
        super.delete(new WhereBuilder("interest_id", (Object)interestId));
    }
}

