/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.es.PsCampaignVO;
import com.thebeastshop.scm.po.Campaign;
import java.util.List;
import org.apache.commons.collections.map.HashedMap;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table="campaign")
public class CampaignDao
extends BaseDao<Campaign> {
    @Autowired
    public CampaignDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<PsCampaignVO> matchProductCampaigns(Long productId, Long categoryId) {
        HashedMap params = new HashedMap();
        params.put("productId", productId);
        params.put("categoryId", categoryId);
        List list = super.selectList("matchProductCampaigns", (Object)params);
        return PsCampaignVO.transfer((List)list);
    }

    public List<PsCampaignVO> findAllCampaignList() {
        List list = super.selectList(new WhereBuilder());
        return PsCampaignVO.transfer((List)list);
    }

    public List<PsCampaignVO> findCampaignsBySkuCode(String skuCode) {
        List skuCampaigns = super.selectList("getCampaignBySkuCode", (Object)skuCode);
        return PsCampaignVO.transfer((List)skuCampaigns);
    }

    public List<PsCampaignVO> findCampaignListByIds(List<Integer> ids) {
        List list = super.selectList(new WhereBuilder().in(this.primaryKeyName, ids));
        return PsCampaignVO.transfer((List)list);
    }

    public List<PsCampaignVO> findProductCampaignsByIds(List<Long> campaignIds) {
        List productCampaigns = super.selectList("findProductCampaignsByIds", campaignIds);
        return PsCampaignVO.transfer((List)productCampaigns);
    }

    public List<PsCampaignVO> findSkuCampaignsByIds(List<Long> campaignIds) {
        List skuCampaigns = super.selectList("findSkuCampaignsByIds", campaignIds);
        return PsCampaignVO.transfer((List)skuCampaigns);
    }

    public List<Integer> getProductIdsByCampaignIds(List<Long> campaignIds) {
        return super.selectList("getProductIdsByCampaignIds", campaignIds);
    }

    public List<Integer> getCategoryIdsByCampaignIds(List<Long> campaignIds) {
        return super.selectList("getCategoryIdsByCampaignIds", campaignIds);
    }

    public List<Integer> getSpvIdsByCampaignIds(List<Long> skuCampaignIds) {
        return super.selectList("getSpvIdsByCampaignIds", skuCampaignIds);
    }
}

