package com.thebeastshop.scm.dao;

import java.util.List;

import static com.thebeastshop.scm.po.InterestFreeProduct.*;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.InterestFreeProduct;

@DaoConfig(table = "interest_free_product")
public class InterestFreeProductDao extends BaseDao<InterestFreeProduct>{

	@Autowired
	public InterestFreeProductDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<InterestFreeProduct> selectProduct(Integer interestFreeId) {
		return super.selectList(new WhereBuilder()
			.eq(F_INTEREST_FREE_ID, interestFreeId).eq(F_BINGDING_TYPE, 0));
	}
	
	public int batchDelete(Integer interestFreeId, Integer bingdingType) {
		return super.delete(new WhereBuilder()
			.eq(F_INTEREST_FREE_ID, interestFreeId).eq(F_BINGDING_TYPE, bingdingType));
	}
	
	/**
	 * 查询适用商品类目ID
	 * @Methods Name selectProductCategory
	 * @Create In 2017-3-23 By Xiang.Gao
	 */
	public List<Long> selectProductCategory(Integer interestFreeId) {
		return super.selectFieldList(F_BINGDING_ID, new WhereBuilder()
			.eq(F_BINGDING_TYPE, 1).eq(F_INTEREST_FREE_ID, interestFreeId));
	}
	
	/**
	 * 批量添加适用商品
	 * @Methods Name batchInsert
	 * @Create In 2017-3-23 By Xiang.Gao
	 */
	public int batchInsert(List<InterestFreeProduct> interestFreeProducts) {
		return super.insertBatch(interestFreeProducts);
	}
}
