package com.thebeastshop.scm.dao;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.thebeastshop.scm.po.InterestFree.*;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.InterestFree;
import com.thebeastshop.scm.vo.interest.InterestFreeVO;

/**
 * 免邮权益Dao 
 * @Class Name InterestFreeDao
 * @Author Xiang.Gao
 * @Create In 2017-3-22
 */
@DaoConfig(table = "interest_free")
public class InterestFreeDao extends BaseDao<InterestFree>{

	@Autowired
	public InterestFreeDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<InterestFreeVO> queryList(InterestFreeVO interestFreeVO) {
		return super.selectList("selectInterestFree", interestFreeVO.toMap());
	}
	
	public List<InterestFreeVO> selectByMemberId(Integer memberId, 
			String accessWay, Integer crossBorderFlag) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("memberId", memberId);
		map.put("accessWay", accessWay);
		map.put("crossBorderFlag", crossBorderFlag);
		return super.selectList("selectByMemberId", map);
	}
	
	public List<InterestFreeVO> selectByBingdingIds(List<Integer> ids,List<Integer> bingdingIds) {
		Map<String,List<Integer>> map = new HashMap<String,List<Integer>>();
		map.put("ids", ids);
		map.put("bingdingIds", bingdingIds);
		return super.selectList("selectByBingdingIds", map);
	}
	
	public boolean selectExclude(Integer interestFreeId,List<Integer> bingdingIds) {
		Map<String ,Object> map = new HashMap<String, Object>();
		map.put("interestFreeId", bingdingIds);
		map.put("bingdingIds", bingdingIds);
		return super.selectList("selectExclude", map).size() > 0;
	}
	
	public InterestFreeVO selectByProvideId(Integer provideId) {
		return super.selectOne("selectByProvideId", provideId);
	}
	
	/**
	 * 更新免邮权益领取数(乐观锁)
	 * @Methods Name updateReceived
	 * @Create In 2017-3-23 By Xiang.Gao
	 */
	public int updateReceived(Integer id, Integer receivedTotal) {
		return super.update(new UpdateBuilder().updateIncr(F_RECEIVED_TOTAL)
				.whereEq(F_RECEIVED_TOTAL, receivedTotal).whereEq(F_ID, id));
	}

}
