package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.CommGlobalConfig.F_CONFIG_KEY;
import static com.thebeastshop.scm.po.CommGlobalConfig.F_CONFIG_VALUE;

import java.util.List;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;
import pers.richard.ormybatis.util.ObjUtils;

import com.thebeastshop.scm.po.CommGlobalConfig;

@DaoConfig(table = "t_comm_global_config")
public class CommGlobalConfigDao extends BaseDao<CommGlobalConfig>{
	
	@Autowired
	public CommGlobalConfigDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public String getValueByKey(String key){
		List<String> list = super.selectFieldList(F_CONFIG_VALUE, new WhereBuilder(F_CONFIG_KEY, key));
		return ObjUtils.get(list, 0);
	}
}