package com.thebeastshop.scm.dao;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.thebeastshop.scm.po.SalesOrder;
import com.thebeastshop.scm.vo.SalesOrderVO;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table = "t_op_sales_order")
public class SalesOrderDao extends BaseDao<SalesOrder>{
	
	@Autowired
	public SalesOrderDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}

	/**
	 * 获取订单相关信息
	 * 
	 * @param params
	 * @return
	 */
	public List<SalesOrderVO> querySalesOrderVOByParams(Map<String,Object> params) {
		return super.selectList("querySalesOrderVOByParams", params);
	}

	/**
	 * 根据会员code查询所有订单总金额（有支付时间  且  状态不为 取消  的）
	 * @param memberCode
	 * @return
	 */
	public BigDecimal queryTotalConsumptionAmountByMemberCode(String memberCode){
		return super.selectOne("queryTotalConsumptionAmountByMemberCode", memberCode);
	}
}