package com.thebeastshop.scm.dao;

import java.util.Date;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.InterestMember;

@DaoConfig(table = "interest_member")
public class InterestMemberDao extends BaseDao<InterestMember>{
	
	@Autowired
	public InterestMemberDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}

	public void save(Integer memberId, Integer interestId) {
		InterestMember interestMember = new InterestMember();
		interestMember.setMemberId(memberId);
		interestMember.setInterestId(interestId);
		interestMember.setIsCash(0);
		interestMember.setCreateTime(new Date());
		interestMember.setUpdateTime(new Date());
		super.insert(interestMember);
	}
	
}