package com.thebeastshop.scm.dao;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.SkuCombination;

@DaoConfig(table = "t_pcs_sku_combination")
public class SkuCombinationDao extends BaseDao<SkuCombination>{
	
	@Autowired
	public SkuCombinationDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<Map> getSubSkuCodeAndQuantityBySpvId(Integer spvId){
		return super.selectList("getSubSkuCodeAndQuantityBySpvId", spvId);
	}
	
	public List<String> getSubSkuCodeByProductId(Integer productId){
		return super.selectList("getSubSkuCodeByProductId", productId);
	}
	
	
	
}