package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.RecommendProductAuto.*;
import static pers.richard.ormybatis.domain.po.IdPo.F_ID;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.RecommendProductAuto;

@DaoConfig(table = "recommend_product_auto")
public class RecommendProductAutoDao extends BaseDao<RecommendProductAuto>{
	
	@Autowired
	public RecommendProductAutoDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<RecommendProductAuto> autoList(String position, String type, String sourceProductCode) {
		WhereBuilder wb = new WhereBuilder(F_POSITION, position).eq(F_TYPE, type).isNotNull(F_SORT);
		if (RecommendProductAuto.Position.PROD_DETAIL.toString().equals(position)) {
			wb.eq(F_SOURCE_PRODUCT_CODE, sourceProductCode);
		}
		wb.orderAsc(F_SORT);
		return super.selectList(wb);
	}
	
	public List<String> getProcutCodeByPosition(String position, String sourceProductCode, Integer limitSize) {
		WhereBuilder wb = new WhereBuilder(F_POSITION, position.toString()).eq(F_STATUS, 1).isNotNull(F_SORT);
		if (RecommendProductAuto.Position.PROD_DETAIL.toString().equals(position)) {
			wb.eq(F_SOURCE_PRODUCT_CODE, sourceProductCode);
		}
		wb.orderAsc(F_TYPE).orderAsc(F_SORT).orderDesc(F_RECOMMEND_PRODUCT_CODE).limit(limitSize);
		return super.selectFieldList(F_RECOMMEND_PRODUCT_CODE, wb);
	}
	
	/**
	 * 查询被屏蔽的记录
	 */
	public List<String> getMaskingProcutCodeByPosition(RecommendProductAuto.Position position, String sourceProductCode) {
		WhereBuilder wb = new WhereBuilder(F_POSITION, position).eq(F_STATUS, 0);
		if (RecommendProductAuto.Position.PROD_DETAIL.toString().equals(position)) {
			wb.eq(F_SOURCE_PRODUCT_CODE, sourceProductCode);
		}
		return super.selectFieldList(F_RECOMMEND_PRODUCT_CODE, wb);
	}
	
	public void save(List<RecommendProductAuto> list){
		if (CollectionUtils.isEmpty(list)) {
			return;
		}
		String position = list.get(0).getPosition();
		WhereBuilder wb = new WhereBuilder(F_POSITION, position);
		if (RecommendProductAuto.Position.PROD_DETAIL.toString().equals(position)) {
			String sourceProductCode = list.get(0).getSourceProductCode(); 
			wb.eq(F_SOURCE_PRODUCT_CODE, sourceProductCode);
		}
		List<Integer> dbIds = super.selectFieldList(F_ID, wb);
		List<Integer> listIds = new ArrayList<>();
		for (RecommendProductAuto recommendProductAuto : list) {
			super.insertOrUpdate(recommendProductAuto);
			listIds.add(recommendProductAuto.getId());
		}
		Collection<Integer> deleteIds = CollectionUtils.subtract(dbIds, listIds);
		if (CollectionUtils.isNotEmpty(deleteIds)) {
			int num = super.delete(new WhereBuilder().in(F_ID, deleteIds));
			log.info("删除recommend_product_auto表[{}]条记录", num);
		}
	}
	
	public Map<String, RecommendProductAuto> byRecommendProductCodes(List<String> productCodes) {
		if (CollectionUtils.isEmpty(productCodes)) {
			return Collections.EMPTY_MAP;
		}
		List<RecommendProductAuto> list = super.selectList(new WhereBuilder().in(F_RECOMMEND_PRODUCT_CODE, productCodes));
		Map<String, RecommendProductAuto> result = new HashMap<>();
		for (RecommendProductAuto recommendProductAuto : list) {
			String productCode = recommendProductAuto.getRecommendProductCode();
			result.put(productCode, recommendProductAuto);
		}
		return result;
	}
}