package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.ProductUpDownRecord.*;

import java.util.Date;
import java.util.List;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.ProductUpDownRecord;
import com.thebeastshop.scm.po.ProductUpDownTimer;

@DaoConfig(table="t_op_product_up_down_record")
public class ProductUpDownRecordDao extends BaseDao<ProductUpDownRecord>{
	
	@Autowired
	public ProductUpDownRecordDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<ProductUpDownRecord> byChnCanSaleProdId(Integer canSaleProdId) {
		return selectList(new WhereBuilder(F_OP_CHN_CAN_SALE_PROD_ID, canSaleProdId));
	}
	
	/**
	 * 按PROD上下架定时对象来保存
	 */
	public void saveByProductUpDownTimer(ProductUpDownTimer productUpDownTimer){
		ProductUpDownRecord prodctUpDownRecord = new ProductUpDownRecord();
		prodctUpDownRecord.setIsTimer("1");
		prodctUpDownRecord.setDownReason(productUpDownTimer.getReason());
		prodctUpDownRecord.setOpChnCanSaleProdId(productUpDownTimer.getOpChnCanSaleProdId());
		prodctUpDownRecord.setStatus(productUpDownTimer.getStatus());
		prodctUpDownRecord.setCreateUserId(0);
		prodctUpDownRecord.setCreateUserName("管理员");
		prodctUpDownRecord.setCreateAt(new Date());
		this.insert(prodctUpDownRecord);
	}
}