/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.RecommendProductAuto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;
import pers.richard.ormybatis.domain.po.IdPo;

@DaoConfig(table="recommend_product_auto")
public class RecommendProductAutoDao
extends BaseDao<RecommendProductAuto> {
    @Autowired
    public RecommendProductAutoDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<RecommendProductAuto> autoList(String position, String type, String sourceProductCode) {
        WhereBuilder wb = new WhereBuilder("position", (Object)position).eq("type", (Object)type).isNotNull("sort");
        if (RecommendProductAuto.Position.PROD_DETAIL.toString().equals(position)) {
            wb.eq("source_product_code", (Object)sourceProductCode);
        }
        wb.orderAsc("sort");
        return super.selectList(wb);
    }

    public List<String> getProcutCodeByPosition(String position, String sourceProductCode, Integer limitSize) {
        WhereBuilder wb = new WhereBuilder("position", (Object)position.toString()).eq("status", (Object)1).isNotNull("sort");
        if (RecommendProductAuto.Position.PROD_DETAIL.toString().equals(position)) {
            wb.eq("source_product_code", (Object)sourceProductCode);
        }
        wb.orderAsc("type").orderAsc("sort").orderDesc("recommend_product_code").limit(limitSize.intValue());
        return super.selectFieldList("recommend_product_code", wb);
    }

    public List<String> getMaskingProcutCodeByPosition(RecommendProductAuto.Position position, String sourceProductCode) {
        WhereBuilder wb = new WhereBuilder("position", (Object)position).eq("status", (Object)0);
        if (RecommendProductAuto.Position.PROD_DETAIL.toString().equals(position)) {
            wb.eq("source_product_code", (Object)sourceProductCode);
        }
        return super.selectFieldList("recommend_product_code", wb);
    }

    public void save(List<RecommendProductAuto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        String position = list.get(0).getPosition();
        WhereBuilder wb = new WhereBuilder("position", (Object)position);
        if (RecommendProductAuto.Position.PROD_DETAIL.toString().equals(position)) {
            String sourceProductCode = list.get(0).getSourceProductCode();
            wb.eq("source_product_code", (Object)sourceProductCode);
        }
        List dbIds = super.selectFieldList("id", wb);
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (RecommendProductAuto recommendProductAuto : list) {
            super.insertOrUpdate((IdPo)recommendProductAuto);
            listIds.add(recommendProductAuto.getId());
        }
        Collection deleteIds = CollectionUtils.subtract((Iterable)dbIds, listIds);
        if (CollectionUtils.isNotEmpty((Collection)deleteIds)) {
            int num = super.delete(new WhereBuilder().in("id", deleteIds));
            this.log.info("\u5220\u9664recommend_product_auto\u8868[{}]\u6761\u8bb0\u5f55", (Object)num);
        }
    }

    public Map<String, RecommendProductAuto> byRecommendProductCodes(List<String> productCodes) {
        List list = super.selectList(new WhereBuilder().in("recommend_product_code", productCodes));
        HashMap<String, RecommendProductAuto> result = new HashMap<String, RecommendProductAuto>();
        for (RecommendProductAuto recommendProductAuto : list) {
            String productCode = recommendProductAuto.getRecommendProductCode();
            result.put(productCode, recommendProductAuto);
        }
        return result;
    }
}

