package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.CommCity.*;

import java.util.List;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.CommCity;

@DaoConfig(table = "t_comm_city")
public class CommCityDao extends BaseDao<CommCity>{
	
	@Autowired
	public CommCityDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<CommCity> likeName(String value){
		return super.selectList(new WhereBuilder().like(F_FULL_NAME, value));
	}
	
}