package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.es.PsCampaignSectionProductVO;
import com.thebeastshop.scm.es.PsCampaignSectionVO;
import com.thebeastshop.scm.es.PsCampaignVO;
import com.thebeastshop.scm.po.Campaign;
import com.thebeastshop.scm.po.CampaignSection;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import java.util.ArrayList;
import java.util.List;

/**
 * @author gongjun
 * @since 2016-11-17
 */
@DaoConfig(table = "campaign_section")
public class CampaignSectionDao extends BaseDao<CampaignSection> {

    @Autowired
    public CampaignSectionDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }


    public List<PsCampaignSectionVO> findCampaignSectionByCampaignId(Long campaignId) {
        List<PsCampaignSectionVO> voList = new ArrayList<>();
        List<CampaignSection> list = super.selectList(
                new WhereBuilder("campaign_id", campaignId).eq("temp", 0));
        for (CampaignSection campaignSection : list) {
            PsCampaignSectionVO vo = new PsCampaignSectionVO(campaignSection);
            voList.add(vo);
        }
        return voList;
    }


}
