package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.es.PsCampaignVO;
import com.thebeastshop.scm.po.Campaign;
import org.apache.commons.collections.map.HashedMap;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-11-14 */
@DaoConfig(table = "campaign")
public class CampaignDao extends BaseDao<Campaign> {


    @Autowired
    public CampaignDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<PsCampaignVO> matchCampaignList(Long productId, Long categoryId) {
        List<PsCampaignVO> results = new ArrayList<>();
        Map<String, Object> params = new HashedMap();
        params.put("productId", productId);
        params.put("categoryId", categoryId);
        List<Campaign> list = super.selectList("matchCampaignList", params);
        for (Campaign campaign : list) {
            PsCampaignVO vo = new PsCampaignVO(campaign);
            results.add(vo);
        }
        return results;
    }


    public List<PsCampaignVO> findAllCampaignList() {
        List<PsCampaignVO> results = new ArrayList<>();
        List<Campaign> list = super.selectList(new WhereBuilder());
        for (Campaign campaign : list) {
            PsCampaignVO vo = new PsCampaignVO(campaign);
            results.add(vo);
        }
        return results;
    }


    public List<PsCampaignVO> findCampaignListByIds(List<Integer> ids) {
        List<PsCampaignVO> results = new ArrayList<>();
        List<Campaign> list = super.selectList(new WhereBuilder().in(primaryKeyName, ids));
        for (Campaign campaign : list) {
            PsCampaignVO vo = new PsCampaignVO(campaign);
            results.add(vo);
        }
        return results;
    }

    public List<Integer> getProductIdsByCampaignIds(List<Integer> campaignIds) {
        List<Integer> ids = super.selectList("getProductIdsByCampaignIds", campaignIds);
        return ids;
    }

    public List<Integer> getCategoryIdsByCampaignIds(List<Integer> campaignIds) {
        List<Integer> ids = super.selectList("getCategoryIdsByCampaignIds", campaignIds);
        return ids;
    }

}
