/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.es.PsSpvVO;
import com.thebeastshop.scm.po.ProdSku;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;
import pers.richard.ormybatis.domain.po.IdPo;

@DaoConfig(table="t_op_prod_sku")
public class ProdSkuDao
extends BaseDao<ProdSku> {
    @Autowired
    public ProdSkuDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public void save(Integer productId, String skuCode, Integer minAmount) {
        ProdSku prodSku = new ProdSku();
        prodSku.setProductId(productId);
        prodSku.setSkuCode(skuCode);
        prodSku.setMinAmount(minAmount);
        super.insertOrUpdate((IdPo)prodSku, new WhereBuilder("product_id", (Object)productId).eq("sku_code", (Object)skuCode));
    }

    public List<Long> getAllIds() {
        return super.selectFieldList("id", new WhereBuilder().gt("id", (Object)0));
    }

    public List<PsSpvVO> getEsSpvVOs(List<Long> spvIds) {
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("ids", spvIds);
        List prodSkuList = super.selectList("getSpvByIds", params);
        ArrayList<PsSpvVO> result = new ArrayList<PsSpvVO>();
        for (ProdSku prodSku : prodSkuList) {
            PsSpvVO spvVO = new PsSpvVO(prodSku);
            result.add(spvVO);
        }
        return result;
    }

    public List<PsSpvVO> getEsSpvVObyProductId(Integer productId) {
        List prodSkuList = super.selectList("getSpvByProductId", (Object)productId);
        ArrayList<PsSpvVO> result = new ArrayList<PsSpvVO>();
        for (ProdSku prodSku : prodSkuList) {
            PsSpvVO spvVO = new PsSpvVO(prodSku);
            result.add(spvVO);
        }
        return result;
    }

    public List<String> findSkuCodeByCombinedSpvId(Integer spvId) {
        return super.selectList("findSkuCodeByCombinedSpvId", (Object)spvId);
    }

    public BigDecimal getMinSalePrice(List<Integer> spvIds) {
        return (BigDecimal)super.selectOne("getMinSalePrice", spvIds);
    }
}

