package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.RecommendProduct.F_RECOMMEND_ID;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.Recommend;
import com.thebeastshop.scm.po.RecommendProduct;

@DaoConfig(table = "recommend_product")
public class RecommendProductDao extends BaseDao<RecommendProduct>{
	
	@Autowired
	public RecommendProductDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	
	public List<String> getProductCodeByCart(String rule){
		Map map = new HashMap();
		map.put("position", Recommend.Position.CART.toString());
		map.put("rule", rule);
		return super.selectList("getProductCodeByPosition", Recommend.Position.CART.toString());
	}
	
	public List<Map> getProductListMapByRecommendId(Integer recommendId){
		return super.selectList("getProductListMapByRecommendId", recommendId);
	}

	public void save(List<String> productCode, Integer recommendId) {
		super.delete(new WhereBuilder(F_RECOMMEND_ID, recommendId));
		for (String code : productCode) {
			RecommendProduct recommendProduct = new RecommendProduct();
			recommendProduct.setProductCode(code);
			recommendProduct.setRecommendId(recommendId);
			super.insert(recommendProduct);
		}
	}
	
}