/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.Recommend;
import com.thebeastshop.scm.po.RecommendProduct;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;
import pers.richard.ormybatis.domain.po.IdPo;

@DaoConfig(table="recommend_product")
public class RecommendProductDao
extends BaseDao<RecommendProduct> {
    @Autowired
    public RecommendProductDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<String> getProductCodeByCart() {
        return super.selectList("getProductCodeByPosition", (Object)Recommend.Position.CART.toString());
    }

    public List<Map> getProductListMapByRecommendId(Integer recommendId) {
        return super.selectList("getProductListMapByRecommendId", (Object)recommendId);
    }

    public void save(List<String> productCode, Integer recommendId) {
        super.delete(new WhereBuilder("recommend_id", (Object)recommendId));
        for (String code : productCode) {
            RecommendProduct recommendProduct = new RecommendProduct();
            recommendProduct.setProductCode(code);
            recommendProduct.setRecommendId(recommendId);
            super.insert((IdPo)recommendProduct);
        }
    }
}

