package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.Recommend.*;

import java.util.List;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.Recommend;

@DaoConfig(table = "recommend")
public class RecommendDao extends BaseDao<Recommend>{
	
	@Autowired
	public RecommendDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public Recommend byPosition(String position){
		return super.selectOne(new WhereBuilder(F_POSITION, position));
	}

	public List<Recommend> findAll() {
		return super.selectList(new WhereBuilder().gt(F_ID, 0));
	}
}
