package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.es.PsSkuCustomizationVO;
import com.thebeastshop.scm.po.SkuCombination;
import com.thebeastshop.scm.po.SkuCustomization;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.support.ManagedProperties;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-11-15
 */
@DaoConfig(table = "t_pcs_sku_customization")
public class SkuCustomizationDao extends BaseDao<SkuCustomization> {

    @Autowired
    public SkuCustomizationDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<PsSkuCustomizationVO> findBySkuCode(String skuCode) {
        List<PsSkuCustomizationVO> voList = new ArrayList<>();
        Map<String, Object> params = new HashMap<>();
        params.put("skuCode", skuCode);
        List<SkuCustomization> list = super.selectList("findSkuCustomizationByIdsfindBySkuCode", params);
        for (SkuCustomization skuCustomization : list) {
            voList.add(new PsSkuCustomizationVO(skuCustomization));
        }
        return voList;
    }



}
