package com.thebeastshop.scm.dao;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.LotteryActivityPrizeRecord;
import com.thebeastshop.scm.vo.lottery.LotteryActivityRecordVO;

@DaoConfig(table = "lottery_activity_prize_record")
public class LotteryActivityPrizeRecordDao extends BaseDao<LotteryActivityPrizeRecord>{
	
	@Autowired
	public LotteryActivityPrizeRecordDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 今天有没有抽过奖
	 * @param memberId
	 * @param lotteryActivityId 
	 * @return 抽过奖今天true,反之false
	 */
	public boolean isDrawLotteryByToday(Integer memberId, Integer lotteryActivityId) {
		Map params = new HashMap();
		params.put("memberId", memberId);
		params.put("lotteryActivityId", lotteryActivityId);
		params.put("nowTime", DateFormatUtils.format(new Date(), "yyyy-MM-dd"));
		Integer result = super.selectOne("isDrawLotteryByDay", params);
		return result != null;
	}
	
	/**
	 * 查询中奖的记录
	 * @param memberId
	 * @param lotteryActivityId
	 * @return
	 */
	public List<LotteryActivityRecordVO> getWinByMemberIdAndLotteryActivityId(Integer memberId, Integer lotteryActivityId) {
		Map params = new HashMap();
		params.put("isWin", 1);
		params.put("memberId", memberId);
		params.put("lotteryActivityId", lotteryActivityId);
		return super.selectList("getLotteryActivityRecordVO", params);
	}
	/**
	 * 查询最近中奖的记录
	 * @return
	 */
	public List<LotteryActivityRecordVO> lastNewest(Integer limit) {
		Map params = new HashMap();
		params.put("limitSize", limit);
		return super.selectList("getLotteryActivityRecordVO", params);
	}
	
	/**
	 * 中奖信息按中奖记录ID
	 */
	public LotteryActivityRecordVO getRecordVOById(Integer lotteryActivityPrizeRecordId) {
		Map params = new HashMap();
		params.put("id", lotteryActivityPrizeRecordId);
		return super.selectOne("getLotteryActivityRecordVO", params);
	}
}