/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.LotteryActivityPrizeRecord;
import com.thebeastshop.scm.vo.lottery.LotteryActivityQueryWinVO;
import com.thebeastshop.scm.vo.lottery.LotteryActivityWinScrollVO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table="lottery_activity_prize_record")
public class LotteryActivityPrizeRecordDao
extends BaseDao<LotteryActivityPrizeRecord> {
    @Autowired
    public LotteryActivityPrizeRecordDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public boolean isDrawLotteryByToday(Integer memberId, Integer lotteryActivityId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("memberId", memberId);
        params.put("lotteryActivityId", lotteryActivityId);
        params.put("nowTime", DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
        Integer result = (Integer)super.selectOne("isDrawLotteryByDay", params);
        return result != null;
    }

    public List<LotteryActivityQueryWinVO> getWinList(Integer memberId, Integer lotteryActivityId) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("memberId", memberId);
        params.put("lotteryActivityId", lotteryActivityId);
        return super.selectList("getWinList", params);
    }

    public LotteryActivityQueryWinVO getWinByLotteryActivityPrizeRecordId(Integer lotteryActivityPrizeRecordId) {
        return (LotteryActivityQueryWinVO)super.selectOne("getWinByLotteryActivityPrizeRecordId", (Object)lotteryActivityPrizeRecordId);
    }

    public List<LotteryActivityWinScrollVO> lastNewest(Integer limit) {
        return super.selectList("lastNewest", (Object)limit);
    }
}

