package com.thebeastshop.scm.dao;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.LotteryActivityPrizeDrawRecord;

@DaoConfig(table = "lottery_activity_prize_draw_record")
public class LotteryActivityPrizeDrawRecordDao extends BaseDao<LotteryActivityPrizeDrawRecord>{
	
	@Autowired
	public LotteryActivityPrizeDrawRecordDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 今天有没有抽过奖
	 * @param memberId
	 * @param lotteryActivityId 
	 * @return 抽过奖今天true,反之false
	 */
	public boolean isDrawLotteryByToday(Integer memberId, Integer lotteryActivityId) {
		Map params = new HashMap();
		params.put("memberId", memberId);
		params.put("lotteryActivityId", lotteryActivityId);
		params.put("nowTime", DateFormatUtils.format(new Date(), "yyyy-MM-dd"));
		Integer result = super.selectOne("isDrawLotteryByDay", params);
		return result != null;
	}
	
}